import os
import numpy as np
import pickle
from src import roc_mc_general as roc
from matplotlib import pyplot as plt
import scipy as sp

print("Current working directory:", os.getcwd())

def process(prefix:str) -> list:
    '''
    Process the log and write corresponding statistics.
    
    Translate '.dat' files into '.stat' fiels.
    prefix = './data/DIR/'
    e.g. prefix = './data/varying_M/'
    '''
    # prefix = './data/varying_M/'
    filenames = [prefix + x for x in list(os.walk(prefix))[0][2] if x[-4:]==".dat"]

    for filename in filenames:
        with open(filename, "rb") as fp:
            raw = pickle.load(fp)

        deltaD_post = np.array([[y[1] for y in z] for z in raw['result']])
        s = deltaD_post.shape[-2:]
        D_post = deltaD_post.reshape(-1,s[0],s[1])
        post_mean = np.mean(D_post, axis=0)
        post_std = np.std(D_post, axis=0)

        with open(filename[:-4]+".stat", "wb") as fp:
            pickle.dump({"pack": raw["pack_list"][0],
                         "mean": post_mean,
                         "std": post_std}, fp)
            
    return filenames