import os
import numpy as np
import pickle
from src import roc_mc_general as roc

from matplotlib import pyplot as plt
import scipy as sp
from src import process_periodic_raw_data as pro


def preprocess_data(data, loc=1):
    r = []
    for x in data['result']:
        r += x
    r = np.array([x[loc] for x in r])
    return r

def clr(d):
    s = d.shape
    d = d.reshape(-1,s[-1])
    f = np.log(d)
    r = f - np.sum(f, axis=1).reshape(-1,1)/s[-1]
    return r.reshape(s)

def inv_clr(d):
    s = d.shape
    d = d.reshape(-1,s[-1])
    f = np.exp(d)
    r = f / (np.sum(f, axis=1).reshape(-1,1))
    return r.reshape(s)

def sigmoid(x):
    return 1/(1+np.exp(-x))


n, m = 3,3
period = 20
radii = np.linspace(0.3, 0, 10, endpoint=False)
