import experiment

import experiment
from optparse import OptionParser


if __name__ == "__main__":
    parser = OptionParser()
    parser.add_option(
        "-i", "--data-id", dest="data_id", help="the dataset id", type=int, default=223
    )
    parser.add_option(
        "-v",
        "--verbose",
        action="store_true",
        dest="verbose",
        default=False,
        help="don't print status messages to stdout",
    )
    parser.add_option(
        "-r",
        "--regressor",
        action="store",
        type="string",
        dest="regressor",
        default="MLP Regressor",
    )
    parser.add_option(
        "-l",
        "--local_cache",
        action="store",
        type="string",
        dest="local_cache",
        default=None,
    )
    parser.add_option(
        "-s",
        "--sampler_name",
        action="store",
        type="string",
        dest="sampler_name",
        default="Distance",
    )
    parser.add_option(
        "--max-size", dest="max_size", help="max size", type=int, default=7
    )
    parser.add_option("--nb-bins", dest="nb_bins", help="nb bins", type=int, default=4)
    parser.add_option(
        "--nb-exp", dest="nb_exp", help="nb experiments", type=int, default=5
    )
    parser.add_option(
        "--nb-train", dest="nb_train", help="nb train", type=int, default=1000
    )
    parser.add_option(
        "--nb-test", dest="nb_test", help="nb test", type=int, default=1000
    )
    parser.add_option("--spread", dest="spread", help="spread", type=float, default=1.0)
    parser.add_option(
        "--timeout-mip",
        dest="timeout_mip",
        help="timeout for the MPI approach",
        type=int,
        default=2,
    )

    (options, args) = parser.parse_args()

    # Main object
    main = experiment.Experiment(
        data_id=options.data_id,
        regressor_name=options.regressor,
        sampler_name=options.sampler_name,
        # explainer_names=["CVX", "LIME", "IHT", "MAPLE", "MIP", "GUROBI"], # Only if you have Gurobi!
        explainer_names=["CVX", "LIME", "IHT", "MAPLE", "MIP"], # MIP is the SCIP solver
        maxsize=options.max_size,
        nb_bins=options.nb_bins,
        nb_experiments=options.nb_exp,
        nb_train=options.nb_train,
        nb_test=options.nb_test,
        spread=options.spread,
        data_home=options.local_cache,
        verbosity_model=options.verbose,
        timeout_mip=options.timeout_mip,
    )

    main.init()
    main.run()
    main.save()
