## Probabilistic Explanations for Regression Models

The framework includes the following files:
- *main.py*: the main function used to compare the different explainers
- *experiment.py*: an interface to experiments
- *dataset.py*: a class used to load the dataset, binarize data instances, and collect statistics 
- *regressor.py*: a class used to train the regressor, and collect statistics  
- *sampler.py*: a class implementing the parameterized distribution in the paper
- *explainer_cvx.py*: the code of the CVX optimizer (using the L1 constraint)
- *explainer_gurobi.py*: a Gurobi implementation of the MIP explainer 
- *explainer_mip.py*: a SCIP implementation of the MIP explainer
- *explainer_iht.py*: the code of the IHT explainer (including k-sparse projections) 
- *explainer_lime.py*: a frontend to the LIME explainer for regression tasks
- *explainer_maple.py*: a frontend to the MAPLE explainer for regression tasks

**Notes:**
- Use *main1.py* and *experiment1.py* only if you have Gurobi.
- A dictionary of dataset names and identifiers is available in *dataset.py*
- A dictionary of regressor names is available in *regressor.py*

## Set Up the Environment  

Before running the program, you need to set up a virtual environment and install the required dependencies. You can do this using the following commands:  

```bash
# Create a virtual environment
python -m venv venv  

# Activate the virtual environment (Linux/macOS)
source venv/bin/activate  

# Install dependencies
python3 -m pip install -r requirements.txt  
```

## View Available Command-Line Options 

To see the available parameters and usage options, you can print the help message by running:

```bash
python main.py -h  
```