# A Practical Guide to Statistical Distances for Evaluating Generative Models in Science

Generative models are highly useful in many disciplines of science. How do we evaluate them? As the data generated by these models is often high-dimensional and/or non-parametric, we can typically not resort to classical statistical tests. This paper aims to provide an accessible entry point to a understanding popular statistical distances proposed and adopted by the machine learning in science community, requiring only foundational knowledge in mathematics or statistics. We focus on four commonly used classes of statistical distances: obtaining a distance using classifiers (e.g. classifier two-sample tests), using embeddings through kernels (e.g. Maximum Mean Discrepancy) or neural networks (e.g. Frechet Inception Distance), and slicing (e.g. sliced Wasserstein). We highlight their merits, scalability, complexity and pitfalls, which are all illustrated in accompanying notebooks. We then use these metrics to compare generative models from two different scientific domains, primate decision modeling in cognitive neuroscience and chest x-rays in medical imaging. We this aim to empower researchers to use, critically assess and interpret statistical distances for generative models in science.

{% include "../README.md" %}