from dataclasses import dataclass, field
from typing import Any, List, Optional, Tuple, Union
from hydra.core.config_store import ConfigStore
from omegaconf import MISSING
from .enums import ResNetType


@dataclass
class ModelConfig:
    name: str = MISSING
    group: str = "model"


@dataclass
class ResNet(ModelConfig):
    name: str = "resnet"
    resnet_type: ResNetType = ResNetType.resnet18
    pretrain: bool = False
