GPU_ID=0
SEED=42
DATE=`date "+%m%d"`

model_name=llava-1.5-7b
# model_name=llava-1.5-13b
max_new_tokens=512
num_samples=500
data_path=../dataset
dataset=chair

# Decoding methods
# greedy opera vcd pai devils beam dola
method=greedy

# Whether to use our method
use_ours=False
k_sig=1.1

# Update experiment name based on use_ours flag
if [ "$use_ours" = True ]; then
    EXP=${model_name}_${method}_token${max_new_tokens}_${SEED}_n${num_samples}_use_ours
else
    EXP=${model_name}_${method}_token${max_new_tokens}_${SEED}_n${num_samples}
fi

result_path=./results/$dataset/$DATE/$EXP
outputjson=$result_path/captions_eval_results.json
echo $result_path
mkdir -p $result_path

# Chair Generation
CMD="CUDA_VISIBLE_DEVICES=$GPU_ID python -m eval_scripts.eval_caption \
--model $model_name \
--dataset_name $dataset \
--image_folder $data_path/coco/val2014 \
--attack_folder $data_path/coco/fast_attack_chairs_eps_3_step_200 \
--caption_file_path $data_path/coco/annotations/captions_val2014.json \
--seed $SEED \
--output_dir $result_path \
--max_new_tokens $max_new_tokens \
--num_samples $num_samples \
--decoder $method \
--verbosity"

# Append our method args if enabled
if [ "$use_ours" = True ]; then
    CMD="$CMD --use_ours --k_sig $k_sig"
fi

# Execute generation
eval $CMD

# Chair Evaluation
python eval_scripts/eval_utils/chair.py \
--cap_file $result_path/captions.jsonl \
--image_id_key question_id \
--caption_key text \
--cache chair.pkl \
--coco_path $data_path/coco/annotations \
--save_path $outputjson
