# Overtone: Supplementary Materials for ICLR 2026

This supplementary material contains the code implementation and experimental resources for "Overtone: Cyclic Patch Modulation for Cleaner, Faster Physics Emulators".

## Contents

### 1. `overtone_modules/`
Core implementation of Overtone's architecture-agnostic modules:
- **encoders/**: Encoder implementations for different patch sizes
- **decoders/**: Decoder implementations for reconstruction
- **shared_utils/**: Utility functions for patch modulation

Key components:
- CSM (Cyclic Stride Modulator): Dynamic stride-based patch size control
- CKM (Cyclic Kernel Modulator): Kernel interpolation for flexible tokenization

### 2. `experiments_code/`
Complete experimental framework and datasets:
- **datasets/**: Data loading and preprocessing utilities
- **scripts/**: Training and evaluation scripts
- **tests/**: Unit tests for core functionality
- **the_well/**: Integration with The Well benchmark suite

## Installation

```bash
# Install dependencies
pip install -r experiments_code/pyproject.toml
```

## Usage

### Running Overtone with CSM
```python
from overtone_modules.encoders import CSMEncoder
from overtone_modules.decoders import CSMDecoder

# Initialize with cyclic patch schedule
encoder = CSMEncoder(patch_sizes=[8, 16, 32])
decoder = CSMDecoder(patch_sizes=[8, 16, 32])
```

### Running experiments
```bash
cd experiments_code
python scripts/train_overtone.py --config configs/overtone_csm.yaml
```

## Key Features

1. **Harmonic Artifact Mitigation**: Cyclic modulation distributes errors across frequency spectrum
2. **Compute-Adaptive Inference**: Dynamic patch size control without retraining
3. **Architecture-Agnostic**: Works with any transformer-based PDE surrogate

## Citation

If you use this code, please cite our ICLR 2026 submission.

## License

This code is provided for review purposes under the ICLR 2026 submission guidelines.