# Periodic shear flow

**One line description of the data:** 2D periodic incompressible shear flow.

**Longer description of the data:**
A shear flow is a type of fluid characterized by the continuous deformation of adjacent fluid layers sliding past each other with different velocities. This phenomenon is commonly observed in various natural and engineered systems, such as rivers, atmospheric boundary layers, and industrial processes involving fluid transport.
The dataset explores a 2D periodic shearflow governed by incompressible Navier-Stokes equation.

**Associated paper**: [Paper 1](https://www.sciencedirect.com/book/9780124059351/fluid-mechanics), [Paper 2](https://journals.aps.org/prfluids/abstract/10.1103/PhysRevFluids.6.100504), [Paper 3](https://journals.aps.org/prfluids/abstract/10.1103/PhysRevFluids.9.014202).

**Data generated by**: [Anonymized for review]

**Code or software used to generate the data**: [Github repository](https://github.com/RudyMorel/the-well-rbc-sf), based on the software [Dedalus](https://dedalus-project.readthedocs.io/en/latest/pages/examples/ivp_2d_shear_flow.html).

**Equation**:

While we solve equations in the frequency domain, the original time-domain problem is

$$
\begin{align*}
\frac{\partial u}{\partial t} + \nabla p - \nu \Delta u & = -u\cdot\nabla u\,,
\\
\frac{\partial s}{\partial t} - D \Delta s & = -u \cdot\nabla s\,,
\end{align*}
$$

where $\Delta = \nabla \cdot \nabla$ is the spatial Laplacian, $u = (u_x,u_y)$ is the (horizontal and vertical) velocity, $s$ is the tracer, and $p$ is the pressure,
with the additional constraints $\int p = 0$ (pressure gauge).

These PDEs are parameterized by the Reynolds and Schmidt numbers through $\nu$ and $D$.

$$
\begin{align*}
\text{(viscosity)} ~~~~~~~ \nu & = 1 / \text{Reynolds}
\\
\text{(diffusivity)} ~~~~~~~ D & = \nu / \text{Schmidt}
\end{align*}
$$

![Gif](https://users.flatironinstitute.org/~polymathic/data/the_well/datasets/shear_flow/gif/tracer_normalized.gif)

| Dataset    | FNO | TFNO  | Unet | CNextU-net
|:-:|:-:|:-:|:-:|:-:|
| `shear_flow`  | 1.189 | 1.472 | 3.447 | $\mathbf{0.8080}$ |

Table: VRMSE metrics on test sets (lower is better). Best results are shown in bold. VRMSE is scaled such that predicting the mean value of the target field results in a score of 1.

## About the data

**Dimension of discretized data:** 200 time-steps of 256 $\times$ 512 images.

**Fields available in the data:** tracer (scalar field), pressure (scalar field), velocity (vector field).

**Number of simulations:** 1120 (28 PDE parameters $\times$ 40 initial conditions).

**Size of the ensemble of all simulations:** 547 GB.

**Grid type:** uniform, cartesian coordinates.

**Initial conditions:** the shear field $u_x$ is composed of $n_\text{shear}$ shears uniformly spaced along the $y$ direction (called "$z$" in the generation script). Each shear is implemented with a tanh (hyperbolic tangent) $\text{tanh}(5\frac{y-y_k}{n_\text{shear}w})$ where $y_k$ is the vertical position of the shear and $w$ is a width factor.
The velocity field $u_y$ is composed of sinusoids along the $x$ direction located at the shear. These sinusoids have an exponential decay away from the shear in the $y$ direction $\text{sin}(n_\text{blobs}\pi x)\,e^{\frac{25}{w^2}|y-y_k|^2}$.
The tracer matches the shear at initialization. The pressure is initialized to zero.
The initial condition is thus indexed by $n_\text{shear},n_\text{blobs},w$.

**Boundary conditions:** periodic.

**Simulation time-step:** 0.1 (simulation time unit).

**Total time range ($t_{min}$ to $t_{max}$):** $t_{min} = 0$, $t_{max} = 20$.

**Spatial domain size:** $0\leq x \leq 1$ horizontally, and $-1 \leq y \leq 1$ vertically.

**Set of coefficients or non-dimensional parameters evaluated:** $\text{Reynolds}\in[1e4, 5e4, 1e5, 5e5], \text{Schmidt}\in[0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0]$. For initial conditions $n_\text{shear}\in[2,4]$, $n_\text{blobs}\in[2,3,4,5]$, $w\in[0.25, 0.5, 1.0, 2.0, 4.0]$.


**Approximate time to generate the data:** per input parameter: $\sim 5h$, total: $\sim 25$ hours.

**Hardware used to generate the data and precision used for generating the data:** 512 nodes of 96 CPU cores each with 96 tasks running in parallel, in double precision.

## What is interesting and challenging about the data:

Shear flow are non-linear phenomena arrising in fluid mechanics and turbulence.
Predicting the behavior of the shear flow under different Reynolds and Schmidt numbers is essential for a number of applications in aerodynamics, automotive, biomedical.
Furthermore, such flow are unstable at large Reynolds number.

Please cite this associated paper if you use this data in your research:

```
@article{burns2020dedalus,
  title={Dedalus: A flexible framework for numerical simulations with spectral methods},
  author={Burns, Keaton J and Vasil, Geoffrey M and Oishi, Jeffrey S and Lecoanet, Daniel and Brown, Benjamin P},
  journal={Physical Review Research},
  volume={2},
  number={2},
  pages={023068},
  year={2020},
  publisher={APS}
}
```
