# Supernova Explosion in a Turbulent Interstellar Medium in Galaxies

**One line description of the data:**
Blastwave in a dense cool gas cloud.

**Longer description of the data:**
The simulations solve an explosion inside a compression of a monatomic ideal gas, which follows the equation of state with the specific heat ratio $\gamma=5/3$.
The gas in these simulations mocks the interstellar medium in the Milky Way Galaxy.
At the beginning of the simulations, the thermal energy of a supernova is dumped at the center of the simulation box.
The hot ($\sim 10^7$ K) gas is immediately accelerated and makes the blastwave.
Because velocities of the hot gas become supersonic, much fine resolution and small timestep are required to resolve the dynamics.
The physical quantities are also distributed in seven orders of magnitude, which requires a large number of simulation steps.

**Associated paper**: [Paper 1](https://academic.oup.com/mnras/article/526/3/4054/7316686), [Paper 2](https://arxiv.org/abs/2311.08460).

**Domain expert**: [Anonymized for review]

**Code or software used to generate the data**: ASURA-FDPS (Smoothed Particle Hydrodynamics), [Github repository](https://github.com/FDPS/FDPS).

**Equation**:

$$
\begin{align*}
P&=(\gamma-1) \rho u \\
\frac{d \rho}{dt} &= -\rho \nabla \cdot \mathbf{v} \\
\frac{d^2 \mathbf{r}}{dt^2}  &= -\frac{\nabla P}{\rho} + \mathbf{a}_{\rm visc}-\nabla \Phi \\
\frac{d u}{dt} &= -\frac{P}{\rho} \nabla \cdot \mathbf{v} + \frac{\Gamma-\Lambda}{\rho}
\end{align*}
$$

where $P$, $\rho$, and $u$ are the pressure. $r$ is the position, $a_{\rm visc}$ is the acceleration generated by the viscosity, $\Phi$ is the gravitational potential, $\Gamma$ is the radiative heat influx per unit volume, and $\Lambda$ is the radiative heat outflux per unit volume.

![Gif](https://users.flatironinstitute.org/~polymathic/data/the_well/datasets/supernova_explosion_64/gif/temperature_normalized.gif)

| Dataset    | FNO | TFNO  | Unet | CNextU-net
|:-:|:-:|:-:|:-:|:-:|
| `supernova_explosion_64`  | 0.3783 | 0.3785 |$\mathbf{0.3063}$|0.3181|

Table: VRMSE metrics on test sets (lower is better). Best results are shown in bold. VRMSE is scaled such that predicting the mean value of the target field results in a score of 1.

## About the data

**Dimension of discretized data** 59 time-steps of  64 $\times$ 64 $\times$ 64 cubes.

**Fields available in the data:**
Pressure (scalar field), density (scalar field), temperature(scalar field), velocity (tensor field).

**Number of trajectories:** 740.

**Estimated size of the ensemble of all simulations:** 268.2 GB.

**Grid type:** uniform, cartesian coordinates.

**Initial conditions:** $820$ random seeds generated using https://github.com/amusecode/amuse/blob/main/src/amuse/ext/molecular_cloud.py (Virialized isothermal gas sphere with turbulence following the velocity spectrum $E(k) \propto k^{-2}$, which is Burgers turbulence ([Burgers 1948](https://www.sciencedirect.com/science/article/abs/pii/S0065215608701005) and [Kupilas+2021](https://doi.org/10.1093/mnras/staa3889) for reference)).

**Boundary conditions:** open.

**Data are stored separated by ($\Delta t$):** $100$ ~ $10\,000$ years (variable timesteps).

**Total time range ($t_{min}$ to $t_{max}$):** $0$ yr to $0.2$ Myr.

**Spatial domain size ($L_x$, $L_y$, $L_z$):** 60 pc.

**Set of coefficients or non-dimensional parameters evaluated:** Initial temperature $T_0$=\{100K\}, Initial number density of hydrogen $\rho_0=$\{44.5/cc\}, metallicity (effectively strength of cooling) $Z=\{Z_0\}$.

**Approximate time to generate the data (CPU hours):**

| 1M $_\odot$ | 0.1 M $\odot$ |
|:----------:|:----------:|
| $300$ | $3\,500$ |

**Hardware used to generate the data and precision used for generating the data:** up to 1040 CPU cores per run.




## What is interesting and challenging about the data:

**What phenomena of physical interest are catpured in the data:**
The simulations are designed as an supernova explosion, which is the explosion at the last moment of massive stars, in a high-density starforming molecular cloud with a large density contrast. An adiabatic compression of a monatomic ideal gas is assumed.
To mimic the explosion, the huge thermal energy ($10^{51}$ erg) is injected at the center of the calculation box and going to make the blastwave, which sweeps out the ambient gas and shells called as supernova feedback. These interactions between supernovae and surrounding gas are interesting because stars are formed in dense and cold regions.

However, calclating the propagation of blastwaves requires tiny timesteps to calculate and numerous integration steps. When supernova feedback is incorporated in a galaxy simulation, some functions fitted using local high resolution simulations have been used.

**How to evaluate a new simulator operating in this space:**
In context of galaxy simulations, the time evolution of thermal energy and momentum are important. We note that those physical quantities are not necessarily conserved because radiative cooling and heating are considered and thermal energy is seamlessly being converted into momentum.

Please cite these associated papers if you use this data in your research:

```
@article{hirashima20233d,
  title={3D-Spatiotemporal forecasting the expansion of supernova shells using deep learning towards high-resolution galaxy simulations},
  author={Hirashima, Keiya and Moriwaki, Kana and Fujii, Michiko S and Hirai, Yutaka and Saitoh, Takayuki R and Makino, Junichiro},
  journal={Monthly Notices of the Royal Astronomical Society},
  volume={526},
  number={3},
  pages={4054--4066},
  year={2023},
  publisher={Oxford University Press}
}
@article{hirashima2023surrogate,
  title={Surrogate Modeling for Computationally Expensive Simulations of Supernovae in High-Resolution Galaxy Simulations},
  author={Hirashima, Keiya and Moriwaki, Kana and Fujii, Michiko S and Hirai, Yutaka and Saitoh, Takayuki R and Makino, Junichiro and Ho, Shirley},
  journal={arXiv preprint arXiv:2311.08460},
  year={2023}
}
```
