# Causal Representation Learning for Instantaneous and Temporal Effects

**For the official public source code release, see https://github.com/phlippe/CITRIS**

This is the anonymized code for the ICLR 2023 submission "Causal Representation Learning for Instantaneous and Temporal Effects".

## Requirements

The code is written in PyTorch (v1.10) and Python 3.8. Higher versions of PyTorch and Python are expected to work as well.
Further, the code base makes use of PyTorch Lightning (v1.6) to structure the training code.

We recommend to use conda for installing the requirements. If you haven't installed conda yet, you can find instructions [here](https://www.anaconda.com/products/individual). The steps for installing the requirements are:

1. Create a new environment from the provided YAML file:
   ```setup
   conda env create -f environment.yml
   ```
   The environment installs PyTorch with CUDA 11.2. Adjust the CUDA version if you want to install it with CUDA 10.2, or remove it from the environment file if you want to install it on a CPU-only system.
   
2. Activate the environment
   ```setup
   conda activate icitris
   ```

### Datasets

__Voronoi benchmark__: The dataset generation file for the Voronoi benchmark can be found in `data/data_generation_voronoi.py`. To generate the datasets which were used for the experiments in the submitted paper, you can use the parameters `graph_type` to select the random, chain, or full instantaneous graph, and `num_causal_vars` to select the graph size (4, 6, 9), and `single_target_interventions` to only intervene on one variable at a time. The datasets in the paper used the seeds 42, 43, 44, 45, and 46.

__Instantaneous Temporal Causal3DIdent__: The dynamics for generating a sequence of causal factors for the (Instantaneous) Temporal Causal3DIdent dataset can be found in `data/data_generation_causal3dident.py`. These latents can be used as input to a Blender generation pipeline, for which we made use of another public [https://github.com/brendel-group/cl-ica](codebase). Due to the dataset size, we cannot provide it here, but plan to release it with corresponding licenses upon publication.

__Causal Pinball__: The dataset generation file for the Causal Pinball dataset can be found in `data/data_generation_pinball.py`. To generate the dataset which was used for the experiments in the submitted paper, you can run `python data_generation_pinball.py --output_folder pinball/`, where `pinball/` is the folder all the data is saved in. This dataset can be directly used in the training files.

## Running experiments

The repository is structured in three main folders:
* `experiments` contains all utilities for running experiments.
* `models` contains the code of CITRIS and the two baselines.
* `data_generation` contains all utilities for creating the dataset, as described before.

For running an experiment, the following steps need to be taken:
1. Train a Causal Encoder (`experiments/train_causal_encoder.py`) on the dataset. This is the supervised CNN used for the triplet evaluation.
2. If experiments with iCITRIS-NF/CITRIS-NF are planed, train an autoencoder (`experiments/train_ae.py`) on the dataset. This is the pretrained autoencoder from which the NF learns a causal representation.
3. Train the respective model (for VAEs, `experiments/train_vae.py`, or for NFs, `experiments/train_nf.py`) where the causal encoder, and eventually the autoencoder, are passed as arguments.

In the public version of the code, we intend to also publish pretrained models for all datasets. 