## Data generation

This folder contains files with which the datasets of this paper can be generated.

### (Instantaneous) Temporal Causal3DIdent

The dataset generation for the (Instantaneous) Temporal Causal3DIdent dataset contains multiple steps, and hence needs multiple files. We summarize them in the folder [`temporal_causal3dident`](temporal_causal3dident/). The Blender processing was adapted from https://github.com/brendel-group/cl-ica.

The first step is to generate a sequence of latent factors, which is implemented in [`data_generation_causal3dident.py`](temporal_causal3dident/data_generation_causal3dident.py). These latents are then taken as input to [`generate_causal3d_images.py`](temporal_causal3dident/generate_causal3d_images.py), which iterates over the time steps and renders according images using Blender. These images are then stacked and saved in a compressed numpy file.

#### Requirements

* Install Blender 2.93.8 (newer versions may not be supported)
* Download the [`data`](https://github.com/brendel-group/cl-ica/tree/master/tools/3dident/data) folder and place in `temporal_causal3dident/data/`
* Add the blender files for the 6 additional shapes ([Armadillo](http://graphics.stanford.edu/data/3Dscanrep/), [Bunny](http://graphics.stanford.edu/data/3Dscanrep/), [Cow](https://www.cs.cmu.edu/~kmcrane/Projects/ModelRepository/#spot), [Dragon](http://graphics.stanford.edu/data/3Dscanrep/), [Head](https://gfx.cs.princeton.edu/proj/sugcon/models/), [Horse](https://www.cc.gatech.edu/projects/large_models/horse.html)) to the folder `temporal_causal3dident/data/shapes/`. The shapes may have to be converted to Blender files first, and rescaled to a suitable size first. Please respect the licenses of the individual shapes.


### Voronoi benchmark

The dataset generation for the Voronoi benchmark is implemented in the file [`data_generation_voronoi.py`](data_generation_voronoi.py). We use the same file to generate various graph structures and the random neural network distributions. Similar to the previous datasets, matplotlib is used to render the images.

### Causal Pinball

The dataset generation for the Causal Pinball dataset is implemented in the file [`data_generation_pinball.py`](data_generation_pinball.py), including the game dynamics with physical collisions and more. While there can occur rare scenarios where the collision calculation is not perfect (e.g. colliding with two objects of opposite direction at the same time), we have not experienced this to be a problem in both training and normal game play dynamics. Note that compared to the other matplotlib datasets, the Causal Pinball dataset is slower to generate since we use a higher resolution (64x64) and several objects need to be rendered.