#!/usr/bin/bash

eval "$(conda shell.bash hook)"
conda activate <name>

filepath_qa=/home/<name>/projects/<name>/data/promqa/assembly101/all.json
filepath_annotation=/home/<name>/projects/<name>/data/promqa/assembly101/preprocess/all_in_one_updated.json
filepath_instruction=/home/<name>/projects/<name>/data/promqa/assembly101/manual/graph/all.json
filepath_template=/home/<name>/projects/<name>/src/benchmark/a101/templates_eval.yaml
dirpath_output=./output/evaluation/
dirpath_log=./log

PYTHONPATH="${PYTHONPATH}:$(pwd)"
export PYTHONPATH

model_id=gpt-4o-2024-11-20
template_type=ternary-step

filenames_prediction=(
    # archive/gpt-4o-2024-11-20_20250808-1627.json
    # gpt-5-2025-08-07_False_all.json
    # gpt-5-2025-08-07_True_all.json
    # gpt-5-mini-2025-08-07_False_all.json
    # gpt-5-mini-2025-08-07_True_all.json
    # archive/gpt-5-mini-2025-08-07_20250813-2330.json
    # archive/gpt-5-mini-2025-08-07_20250814-1044.json
    # archive/claude-3-7-sonnet-20250219_20250818-1040.json
    # gemini-2.5-flash_True_all.json
    # archive/gemini-2.5-flash_20250820-1153.json
    # archive/Qwen2.5-VL-32B-Instruct_20250822-1322.json
    # Qwen2.5-VL-32B-Instruct_False_all.json
    # archive/Qwen2.5-VL-32B-Instruct_20250828-1751.json
    # archive/MiMo-VL-7B-RL-2508_20250910-2127.json
    # archive/InternVL3-38B_20250909-1329.json
    # ours/gpt-5-mini-2025-08-07_True_presample.json
    # ours/Qwen2.5-VL-32B-Instruct_False_presample.json
    # ours/MiMo-VL-7B-RL-2508_False_presample.json
    # ours/gpt-5-2025-08-07_True.json
    # ours/claude-sonnet-4-20250514_True.json
    # ours/gemini-2.5-flash_True_text_updated.json
    # ours/InternVL3-38B_False.json
    # ours/MiMo-VL-7B-RL-2508_True.json
    # ours/MiMo-VL-7B-RL-2508_text_True.json
    # ours/MiMo-VL-7B-RL-2508_True_presample.json
    # ours/Qwen2.5-VL-32B-Instruct_False.json
    # ours/Qwen2.5-VL-32B-Instruct_text_False.json
    # ours/Qwen2.5-VL-32B-Instruct_False_presample.json
    # ours/InternVL3-38B_False.json
    ours/InternVL3-38B_False_presample.json

    # start w/ pre-sampled frames
    # archive/gemini-2.5-flash_20250910-2337_updated.json
    # pre&post sample
    # ours/gemini-2.5-flash_True_pre-postsample.json

    # default/gemini-2.5-flash_False_all.json
    # default/InternVL3-38B_False_all.json
    # default/MiMo-VL-7B-RL-2508_False_all.json
    # default/MiMo-VL-7B-RL-2508_True_all.json
    # default/MiMo-VL-7B-RL-2508_True_all_postprocess.json
    # default/InternVL3-38B_True_all.json
    # default/Qwen2.5-VL-32B-Instruct_True_all.json
    # default/claude-sonnet-4-20250514_False_all.json
    # default/claude-sonnet-4-20250514_True_all.json
    # default/gemini-2.5-pro_True_all.json

    # tcot
    # baseline/tcot_gemini-2.5-flash_False_all.json
    # baseline/tcot_gemini-2.5-flash_True_all.json
    # baseline/tcot_Qwen2.5-VL-32B-Instruct_False_all.json
    # baseline/tcot_gpt-5-mini-2025-08-07_True_all.json
    # baseline/tcot_InternVL3-38B_False_all.json
    # baseline/tcot_MiMo-VL-7B-RL-2508_False_all_postprocess.json
    # baseline/tcot_gpt-5-2025-08-07_True_all.json
    # baseline/tcot_claude-sonnet-4-20250514_True_all.json

    # text version
    # ours/gpt-5-mini-2025-08-07_text_True.json
    # ours/Qwen2.5-VL-32B-Instruct_text_False.json

    # workflow, fixed order
    # workflow/gpt-5-mini-2025-08-07_True_123.json
    # workflow/gpt-5-mini-2025-08-07_True_132.json
    # workflow/gpt-5-mini-2025-08-07_True_213.json
    # workflow/gpt-5-mini-2025-08-07_True_231.json
    # workflow/gpt-5-mini-2025-08-07_True_312.json
    # workflow/gpt-5-mini-2025-08-07_True_321.json
    # workflow/gemini-2.5-flash_True_123.json
    # workflow/gemini-2.5-flash_True_132.json
    # workflow/gemini-2.5-flash_True_213.json
    # workflow/gemini-2.5-flash_True_231.json
    # workflow/gemini-2.5-flash_True_312.json
    # workflow/gemini-2.5-flash_True_321.json
    # workflow/MiMo-VL-7B-RL-2508_True_123.json
    # workflow/MiMo-VL-7B-RL-2508_True_132.json
    # workflow/MiMo-VL-7B-RL-2508_True_213.json
    # workflow/MiMo-VL-7B-RL-2508_True_231.json
    # workflow/MiMo-VL-7B-RL-2508_True_312.json
    # workflow/MiMo-VL-7B-RL-2508_True_321.json
)

for filename_prediction in "${filenames_prediction[@]}"; do

    filepath_prediction=./output/"$filename_prediction"

    python src/evaluate.py \
        --filepath_qa "$filepath_qa" \
        --filepath_prediction "$filepath_prediction" \
        --filepath_annotation "$filepath_annotation" \
        --filepath_instruction "$filepath_instruction" \
        --filepath_template "$filepath_template" \
        --dirpath_output "$dirpath_output" \
        --template_type "$template_type" \
        --model_id "$model_id" \
        --dirpath_log "$dirpath_log"
done
