# TAMA


## Environment Setup
* OS: Ubuntu 24.04.2 LTS x86_64
* GPU: 1\~4 NVIDIA RTX A6000 (48GB)

### Virtual Environment
```bash
conda create -y -n tama python=3.12
conda activate tama
pip install vllm
pip install tqdm pydot datasets pillow pre-commit openai pre-commit
pre-commit install
```

## Download
```bash
python src/download/run.py --target <target>
# <target>: cooking, assembly, both
```

## Experiment
```bash
bash src/run_prototype_openai.sh gpt-5-mini-2025-08-07
bash src/run_prototype_openai_text.sh gpt-5-mini-2025-08-07
bash src/run_prototype_openai_presample.sh gpt-5-mini-2025-08-07
bash src/run_prototype_openai.sh gpt-5-2025-08-07
bash src/run_prototype_openai_text.sh gpt-5-2025-08-07
bash src/run_prototype_openai_presample.sh gpt-5-2025-08-07

bash src/run_prototype_anthropic.sh claude-3-7-sonnet-20250219
bash src/run_prototype_anthropic.sh claude-sonnet-4-20250514

bash src/run_prototype_google.sh gemini-2.5-flash
bash src/run_prototype_google_text.sh gemini-2.5-flash
bash src/run_prototype_google_presample.sh gemini-2.5-flash
bash src/run_prototype_google_pre-postsample.sh gemini-2.5-flash
bash src/run_prototype_google.sh gemini-2.5-pro

bash src/start_vllm.sh Qwen/Qwen2.5-VL-32B-Instruct 4,5,6,7 4
bash src/start_qwen_server.sh Qwen/Qwen2.5-VL-32B-Instruct 4,5,6,7 4 8567
bash src/run_prototype_qwen.sh Qwen/Qwen2.5-VL-32B-Instruct
bash src/run_prototype_qwen_text.sh Qwen/Qwen2.5-VL-32B-Instruct
bash src/run_prototype_qwen_presample.sh Qwen/Qwen2.5-VL-32B-Instruct

bash src/start_mimo_server.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 7 8087
# bash src/start_mimo_server.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 6 8086
bash src/run_prototype_mimo.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 8087
bash src/run_prototype_mimo_text.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 8087
bash src/run_prototype_mimo_presample.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 8087

# internvl3
bash src/start_internvl_server.sh OpenGVLab/InternVL3-38B 0,1,2,3 4
bash src/run_prototype_internvl.sh OpenGVLab/InternVL3-38B
bash src/start_internvl_server_new.sh OpenGVLab/InternVL3-38B 0,1,2,3 4 8456
bash src/run_prototype_internvl_presample.sh OpenGVLab/InternVL3-38B


# benchmarking: default prompt
bash src/run_benchmark.sh gpt-5-2025-08-07 false
bash src/run_benchmark.sh gpt-5-2025-08-07 true
bash src/run_benchmark.sh gpt-5-mini-2025-08-07 false
bash src/run_benchmark.sh gpt-5-mini-2025-08-07 true
bash src/run_benchmark.sh claude-sonnet-4-20250514 false
bash src/run_benchmark.sh claude-sonnet-4-20250514 true
bash src/run_benchmark.sh gemini-2.5-flash false
bash src/run_benchmark.sh gemini-2.5-flash true
# bash src/run_benchmark.sh gemini-2.5-pro false # not available
bash src/run_benchmark.sh gemini-2.5-pro true
bash src/run_benchmark.sh Qwen/Qwen2.5-VL-32B-Instruct false
bash src/run_benchmark.sh Qwen/Qwen2.5-VL-32B-Instruct true
bash src/run_benchmark.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 false
bash src/run_benchmark.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 true
bash src/run_benchmark.sh OpenGVLab/InternVL3-38B false
bash src/run_benchmark.sh OpenGVLab/InternVL3-38B true
```

### Baselines
```bash
bash src/run_tcot_google.sh gemini-2.5-flash
# bash src/run_tcot_google.sh gemini-2.5-pro
bash src/run_tcot_openai.sh gpt-5-mini-2025-08-07
bash src/run_tcot_openai.sh gpt-5-2025-08-07
# bash src/run_tcot_anthropic.sh claude-3-7-sonnet-20250219
bash src/run_tcot_anthropic.sh claude-sonnet-4-20250514
bash src/run_tcot_qwen.sh Qwen/Qwen2.5-VL-32B-Instruct
bash src/run_tcot_internvl.sh OpenGVLab/InternVL3-38B
bash src/run_tcot_mimo.sh XiaomiMiMo/MiMo-VL-7B-RL-2508
```

### Workflow
```bash
bash src/run_workflow_openai.sh gpt-5-mini-2025-08-07
bash src/run_workflow_google.sh gemini-2.5-flash
bash src/start_mimo_server.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 7 8087
bash src/run_workflow_mimo.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 123 8088
bash src/run_workflow_mimo.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 132 8088
# bash src/run_workflow_mimo.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 213 8088
# bash src/run_workflow_mimo.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 231 8088
# bash src/run_workflow_mimo.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 312 8088
# bash src/run_workflow_mimo.sh XiaomiMiMo/MiMo-VL-7B-RL-2508 321 8088
```

###
```bash
bash src/evaluate.sh
```


---
```bash
bash src/run_prototype_openai.sh gpt-4o-2024-11-20
# qwen: start server then run
# bash src/start_vllm.sh Qwen/Qwen2.5-VL-7B-Instruct 4 1
# bash src/start_vllm.sh Qwen/Qwen2.5-VL-72B-Instruct 4,5,6,7 4
# bash src/run_prototype_qwen.sh Qwen/Qwen2.5-VL-7B-Instruct
# bash src/run_prototype_qwen.sh Qwen/Qwen2.5-VL-72B-Instruct
# mini cpm 4.5v
# bash src/start_cpm_server.sh openbmb/MiniCPM-V-4_5 0,1,2,3 4
# bash src/start_cpm_server.sh openbmb/MiniCPM-V-4_5 --trust-remote-code
# # glm 4.5v fp8
# bash src/start_glm_server.sh zai-org/GLM-4.5V-FP8 0,1,2,3 4
```
