#!/usr/bin/bash

eval "$(conda shell.bash hook)"
conda activate <name>

filepath_input=/home/<name>/projects/<name>/data/promqa/assembly101/all.json
filepath_instruction=/home/<name>/projects/<name>/data/promqa/assembly101/manual/graph/all.json
dirpath_instruction_image=/usr1/data/<name>/<name>/a101/original-graphs/
dirpath_parts_image=/usr1/datasets/assembly-101/images/
dirpath_frame=/usr1/data/<name>/<name>/a101/frames/rgb/360p/
filepath_template=./src/templates_benchmark.yaml
dirpath_output=./output/default
dirpath_log=./log

model_id=$1

PYTHONPATH="${PYTHONPATH}:$(pwd)"
export PYTHONPATH

flag_reasoning="$2"

if [[ "$flag_reasoning" == "true" ]]; then
    echo "reasoning mode"
    python src/benchmark_api.py \
        --filepath_input "$filepath_input" \
        --filepath_instruction "$filepath_instruction" \
        --dirpath_instruction_image "$dirpath_instruction_image" \
        --dirpath_parts_image "$dirpath_parts_image" \
        --dirpath_frame "$dirpath_frame" \
        --filepath_template "$filepath_template" \
        --dirpath_output "$dirpath_output" \
        --dirpath_log "$dirpath_log" \
        --model_id "$model_id" \
        --reasoning

elif [[ "$flag_reasoning" == "false" ]]; then
    echo "non-reasoning mode"
    python src/benchmark_api.py \
        --filepath_input "$filepath_input" \
        --filepath_instruction "$filepath_instruction" \
        --dirpath_instruction_image "$dirpath_instruction_image" \
        --dirpath_parts_image "$dirpath_parts_image" \
        --dirpath_frame "$dirpath_frame" \
        --filepath_template "$filepath_template" \
        --dirpath_output "$dirpath_output" \
        --dirpath_log "$dirpath_log" \
        --model_id "$model_id"

else
    echo "Invalid argument: $flag_reasoning"
    echo "Usage: $0 model_id true|false"
    exit 1
fi
