#!/usr/bin/bash

eval "$(conda shell.bash hook)"
conda activate <name>

filepath_qa=/home/<name>/projects/<name>/data/promqa/assembly101/all.json
filepath_instruction=/home/<name>/projects/<name>/data/promqa/assembly101/manual/graph/all.json
dirpath_instruction_image=/usr1/data/<name>/<name>/a101/original-graphs/
dirpath_parts_image=/usr1/datasets/assembly-101/images/
dirpath_frame=/usr1/data/<name>/<name>/a101/frames/rgb/360p/
dirpath_intermediate_output=/usr1/data/<name>/<name>-system/
filepath_template=./src/templates.yaml
filepath_tool=./src/tools.yaml
dirpath_output=./output/ours/
dirpath_log=./log

model_id=$1
threshold_continue=5
max_turn=10

PYTHONPATH="${PYTHONPATH}:$(pwd)"
export PYTHONPATH

python src/prototype_google_presample_postsample.py \
    --filepath_qa "$filepath_qa" \
    --filepath_instruction "$filepath_instruction" \
    --dirpath_instruction_image "$dirpath_instruction_image" \
    --dirpath_parts_image "$dirpath_parts_image" \
    --dirpath_frame "$dirpath_frame" \
    --dirpath_intermediate_output "$dirpath_intermediate_output" \
    --filepath_template "$filepath_template" \
    --filepath_tool "$filepath_tool" \
    --dirpath_output "$dirpath_output" \
    --dirpath_log "$dirpath_log" \
    --model_id "$model_id" \
    --reasoning \
    --threshold_continue "$threshold_continue" \
    --max_turn "$max_turn"
