#!/usr/bin/bash

eval "$(conda shell.bash hook)"
conda activate <name>

filepath_input=/home/<name>/projects/<name>/data/promqa/assembly101/all.json
filepath_instruction=/home/<name>/projects/<name>/data/promqa/assembly101/manual/graph/all.json
dirpath_instruction_image=/usr1/data/<name>/<name>/a101/original-graphs/
dirpath_parts_image=/usr1/datasets/assembly-101/images/
dirpath_frame=/usr1/data/<name>/<name>/a101/frames/rgb/360p/
filepath_template=/home/<name>/projects/<name>-system/src/template_tcot.yaml
dirpath_output=./output/baseline/
dirpath_log=./log

model_id=$1

PYTHONPATH="${PYTHONPATH}:$(pwd)"
export PYTHONPATH

python src/baseline_tcot_mimo.py \
    --filepath_input "$filepath_input" \
    --filepath_instruction "$filepath_instruction" \
    --dirpath_instruction_image "$dirpath_instruction_image" \
    --dirpath_parts_image "$dirpath_parts_image" \
    --dirpath_frame "$dirpath_frame" \
    --filepath_template "$filepath_template" \
    --dirpath_output "$dirpath_output" \
    --dirpath_log "$dirpath_log" \
    --model_id "$model_id"
