
import numpy as np
import torch
import wandb
import warnings
warnings.filterwarnings('ignore')
from pprint import pprint
from inscd import listener
from inscd.datahub import DataHub
from inscd.models.static.neural import NCDM
from inscd.models.static.graph import ULCDF
from inscd.models.static.neural import KANCD
from inscd.models.static.classic import MIRT
from inscd.models.static.neural import KSCD
from inscd.models.static.graph import RCD
from inscd.models.static.graph import LIGHTGCN
from inscd.models.static.neural import DCD
from inscd.models.static.graph import SCD
from inscd.models.static.graph import GCMC
from inscd.models.static.graph import RGCN
from inscd.models.static.graph import ORCDF

# wandb.init(
#     project="test inscd"
# )

listener.update(print)
seed = 2
np.random.seed(seed)
torch.manual_seed(seed)
torch.cuda.manual_seed(seed)

datahub = DataHub("datasets/EdNet-1")
datahub.random_split(source="total", to=["train", "test"], seed=seed)