/**
 * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */

'use strict';



const VERSION = require('../../package.json').version;

const logDebugMessages = (
config,
pipe) =>
{
  /* $FlowFixMe */
  const testFramework = require(config.testRunner);
  pipe.write('jest version = ' + VERSION + '\n');
  pipe.write('test framework = ' + testFramework.name + '\n');
  pipe.write('config = ' + JSON.stringify(config, null, '  ') + '\n');

};

module.exports = logDebugMessages;