import numpy as np
from matplotlib import pyplot as plt

markers = ["o", "v", "*", "s", "h"]


class Colors:
    red = "#C1121F"
    blue = "#3A86FF"
    green = "#76c893"
    orange = "#ffd166"
    dblue = "#073b4c"


def plotci(ax, x, E, exps, color, label, marker='*'):
    y = np.mean(np.cumsum(exps, axis=1), axis=0)
    ax.plot(
        x,
        y,
        color=color,
        label=label,
        marker=marker,
        markevery=len(x) // len(ax.get_xticks()),
        rasterized=True
    )
    ci = 1.96 * np.std(np.cumsum(exps, axis=1), axis=0) / np.sqrt(E)
    ax.fill_between(x, (y - ci), (y + ci), color=color, alpha=0.1)
