
import tensorflow as tf
import numpy as np
import scipy.sparse as sp


# pullaway_loss

def pullaway_loss(embeddings):
    """
    Pull Away loss calculation
    :param embeddings: The embeddings to be orthogonalized for varied faces. Shape [batch_size, embeddings_dim]
    :return: pull away term loss
    """
    norm = tf.sqrt(tf.reduce_sum(tf.square(embeddings), 1, keep_dims=True))
    normalized_embeddings = embeddings / norm
    similarity = tf.matmul(
        normalized_embeddings, normalized_embeddings, transpose_b=True)
    batch_size = tf.cast(tf.shape(embeddings)[0], tf.float32)
    pt_loss = (tf.reduce_sum(similarity) - batch_size) / (batch_size * (batch_size - 1))
    return pt_loss

    
"""
Generate random uniform noise from -1 to 1.
"""

def sample_noise(batch_size, dim):
    """
    
    Inputs:
    - batch_size: integer giving the batch size of noise to generate
    - dim: integer giving the dimension of the the noise to generate
    
    Returns:
    TensorFlow Tensor containing uniform noise in [-1, 1] with shape [batch_size, dim]
    """
    random_noise = tf.random_uniform([batch_size, dim], maxval= 1, minval= -1)
    return random_noise
    

"""
generate feature for fake nodes
"""
def generator_covariate(z, d, hidden_layer = 256 , name = "generator_cov"):
    with tf.variable_scope(name):
        initializer = tf.contrib.layers.xavier_initializer(uniform=True)
        fc1_output = tf.layers.dense(z, hidden_layer, activation = tf.nn.relu,
                                 kernel_initializer=initializer)
        sy_covariates = tf.layers.dense(fc1_output, d, activation = tf.nn.relu, ## tf.nn.relu can make the ouput sparse
                                 kernel_initializer=initializer)
        return sy_covariates

"""
generate link relation for fake nodes
"""
def generator_link(z, n, hidden_layer = 256, name = "generator_link"):
    with tf.variable_scope(name, reuse=tf.AUTO_REUSE):
        initializer = tf.contrib.layers.xavier_initializer(uniform=True)
        fc1_output = tf.layers.dense(z, hidden_layer, activation = tf.nn.relu,
                                 kernel_initializer=initializer)
        sy_logits_na = tf.layers.dense(fc1_output, n, activation = tf.nn.sigmoid, 
                                 kernel_initializer = initializer) 
        return sy_logits_na


### convert dense tensor to sparse tenser

def dense_to_sparse(dense_tensor, out_type):
    indices = tf.where(tf.not_equal(dense_tensor, tf.constant(0, dense_tensor.dtype)))
    values = tf.gather_nd(dense_tensor, indices)
    shape = tf.shape(dense_tensor, out_type=out_type)
    return tf.SparseTensor(indices, values, shape)


