# Supplementary Materials Walk Through

## High-Level Structure

The main folder is organized as follows:

    .
    ├── Appendix.pdf                    # Writeup for the appendix section
    ├── README.md                       # Current document
    ├── code                            # Contains all Python source files
    │   ├── createInitialBenchmark.py   # Main script to create map and visualization
    │   ├── createWarehouse3D.py        # Create 3D warehouse maps
    │   └── visualization.py            # Visualize the 3D maps and animations for the solution              
    ├── 3DMaps                          # Contains the base 3D warehouse maps and real 3D warehouse map
    │   ├── *_Nodes.csv                 # Contains nodes of maps
    │   └── *_Edges.csv                 # Contains edges of maps             
    └── visualizations
        ├── maps                        # Contains visualizations for maps
        │   └── *.html                  # map visualizations are in .html format 
        └── animations              
            └── *.html                  # Click to view animations for solutions

## /code

Example command to create visualization of the map and animation.

```bash
cd code
python createInitialBenchmark.py
```

## /3DMaps

The file prefix for each parametrized warehouse map is defined as follows:

```
aisleLength_numAisles_aisleGap_numLevels_levelGap_numElevators_*.csv
```

There is also a real-world 3D warehouse map named `real_warehouse_*.csv`.

There are two files for one map, namely a `*_Nodes.csv` and a `*_Edges.csv` for which their format is specified in `Appendix.pdf`.

## /visualizations

### /maps

These `.html` files are plug-and-plays for visualizing 3D maps on a web browser. The file prefix is specified in the same fashion.

### /animations

Due to the upload file size limit of the supplementary material, we are only including 1 animation of a 50-agent start-goal problem on the base map.
