import argparse
import subprocess

if __name__ == "__main__":

    warehouse_parameters = [[50, 10, 5, 10, 5, 2],
                            [100, 10, 5, 10, 5, 2],
                            [25, 10, 5, 10, 5, 2],
                            [50, 20, 5, 10, 5, 2],
                            [50, 5, 5, 10, 5, 2],
                            [50, 10, 10, 10, 5, 2],
                            [50, 10, 2, 10, 5, 2],
                            [50, 10, 5, 20, 5, 2],
                            [50, 10, 5, 5, 5, 2],
                            [50, 10, 5, 10, 10, 2],
                            [50, 10, 5, 10, 2, 2],
                            [50, 10, 5, 10, 5, 4],
                            [50, 10, 5, 10, 5, 1],
                            [100, 20, 10, 20, 10, 4],
                            [25, 5, 2, 5, 2, 1]]

    for param in warehouse_parameters:

        arguments = ["-l", str(param[0]),
                     "-na", str(param[1]),
                     "-ag", str(param[2]),
                     "-nl", str(param[3]),
                     "-lg", str(param[4]),
                     "-e", str(param[5]),
                     "-o", "../3DMaps"]
        subprocess.call(['python3', 'createWarehouse3D.py'] + arguments)

        map_type = "{}_{}_{}_{}_{}_{}".format(param[0], param[1], param[2], param[3], param[4], param[5])

        arguments = ["-n", "../3DMaps/" + map_type + "_Nodes.csv",
                     "-e", "../3DMaps/" + map_type + "_Edges.csv",
                     "-o", "../visualizations/maps/" + map_type + ".html"]
                     # "-p", "paths.csv",
                     # "-sp", "../visualizations/animations/" + map_type + ".html"]
        subprocess.call(['python3', 'visualization.py'] + arguments)
