import ray
from loguru import logger


def initialize_ray(num_cpus: int | None = None, num_gpus: int | None = None, **kwargs):
  if not ray.is_initialized():
    try:
      # Try to connect to an existing Ray cluster
      ray.init(address="auto", ignore_reinit_error=True, **kwargs)
      print("Connected to an existing Ray cluster.")
    except ConnectionError:
      # If no existing cluster, start a new one with specified CPU constraints
      ray.init(num_cpus=num_cpus, num_gpus=num_gpus, **kwargs)
      logger.info(f"Started a new Ray cluster with {num_cpus} CPUs.")
  else:
    logger.info("Ray is already initialized.")
