# from uncertainty_for_programs.tasks.apps import Apps  # noqa: F401
# from uncertainty_for_programs.tasks.mbpp import MBPP  # noqa: F401
# from uncertainty_for_programs.tasks.ds1000 import DS1000Task  # noqa: F401
# from uncertainty_for_programs.tasks.taco_simple_train import (
#     TacoSimpleTrain,  # noqa: F401
# )
from llm_inference.tasks.ds1000_simple import DS1000Simple
from llm_inference.tasks.mbpp import MBPP
from llm_inference.tasks.ds1000 import DS1000Task
from llm_inference.tasks.task import Task
from llm_inference.tasks.gsm8k import GSM8k
from llm_inference.tasks.trivia_qa import TriviaQA
from llm_inference.tasks.math import MATH

TASKS: dict[str, Task] = {
  "mbpp-test": MBPP(dataset_split="test"),
  "mbpp-train": MBPP(dataset_split="train"),
  "mbpp-all": MBPP(dataset_split="all"),
  # "ds1000": DS1000Task(),
  "gsm8k-main-train": GSM8k(dataset_name="main", dataset_split="train"),
  "gsm8k-main-test": GSM8k(dataset_name="main", dataset_split="test"),
  "gsm8k-socratic-train": GSM8k(dataset_name="socratic", dataset_split="train"),
  "gsm8k-socratic-test": GSM8k(dataset_name="socratic", dataset_split="test"),
  "ds1000-simple": DS1000Simple(),
  "trivia-qa": TriviaQA(),
  "math-test": MATH(),
}
