from typing import Sequence
from llm_inference.tasks.task import HFTask
import dataclasses


@dataclasses.dataclass
class DS1000Simple(HFTask):
  dataset_path: str = "xlangai/DS-1000"
  dataset_split: str = "test"

  @property
  def stop_tokens(self):
    return ["# SOLUTION END", "</code>"]

  @property
  def output_keys(self):
    return ["prompt", "reference_code", "code_context", "metadata"]

  def get_reference_solutions(self, example: dict):
    return example["reference_code"]

  def prepare_inputs(self, raw_example: dict) -> dict:
    return raw_example

  def get_evaluation_cfg(
    self, indices: Sequence[int], predictions: Sequence[str]
  ) -> tuple[dict, dict | None]:
    del indices, predictions
    raise NotImplementedError(
      "DS1000_simple does not support evaluation via this task."
      "Instead, please use './eval_scripts/ds1000/eval.py for evaluation', "
      "after appropriately setting up the environment as described in 'eval_scripts/ds1000/README.md'"
    )
