if [ ! -d "./logs" ]; then
    mkdir ./logs
fi

if [ ! -d "./logs/LongForecasting" ]; then
    mkdir ./logs/LongForecasting
fi

if [ ! -d "./logs/LongForecasting/IndexNet" ]; then
    mkdir ./logs/LongForecasting/IndexNet
fi

model_name=IndexNet
seq_len=96
GPU=3
root=./dataset

data_name=weather
for pred_len in 96 192 336 720
do
  CUDA_VISIBLE_DEVICES=$GPU \
  python -u run.py \
    --is_training 1 \
    --root_path $root/weather/ \
    --data_path weather.csv \
    --model_id weather_$seq_len_$pred_len \
    --model $model_name \
    --data custom \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --enc_in 21 \
    --dec_in 21 \
    --t_layers 3 \
    --c_in 21 \
    --c_out 21 \
    --des 'Exp' \
    --d_model 512 \
    --d_ff 512 \
    --minute 10 \
    --learning_rate 0.0005 \
    --batch_size 16 \
    --steps_per_day 144 \
    --time_type 'abs' \
    --itr 1 >logs/LongForecasting/IndexNet/$data_name'_'$pred_len.logs
done

data_name=electricity
for pred_len in 96 192 336 720
do
  CUDA_VISIBLE_DEVICES=$GPU \
  python -u run.py \
    --is_training 1 \
    --root_path $root/electricity/ \
    --data_path electricity.csv \
    --model_id electricity_$seq_len_$pred_len \
    --model $model_name \
    --data custom \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --enc_in 321 \
    --dec_in 321 \
    --c_in 321 \
    --c_out 321 \
    --des 'Exp' \
    --d_ff 512 \
    --d_model 512 \
    --t_layers 3 \
    --batch_size 16 \
    --learning_rate 0.001 \
    --steps_per_day 24 \
    --time_type 'abs' \
    --itr 1 >logs/LongForecasting/IndexNet/$data_name'_'$seq_len'_'$pred_len.logs
done

data_name=traffic
for pred_len in 96 192 336 720; do
  CUDA_VISIBLE_DEVICES=$GPU \
  python -u run.py \
    --is_training 1 \
    --root_path $root/traffic/ \
    --data_path traffic.csv \
    --model_id traffic_$seq_len_$pred_len \
    --model $model_name \
    --data custom \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --enc_in 862 \
    --dec_in 862 \
    --c_in 862 \
    --c_out 862 \
    --des 'Exp' \
    --d_ff 1024 \
    --d_model 512 \
    --t_layers 3 \
    --batch_size 16 \
    --train_epochs 10 \
    --learning_rate 0.001 \
    --steps_per_day 24 \
    --month \
    --c_dim 256 \
    --t_dim 256 \
    --itr 1 >logs/LongForecasting/IndexNet/$data_name'_'$seq_len'_'$pred_len.log
done

data_name=ETTh1
for pred_len in 96 192 336 720
do
  CUDA_VISIBLE_DEVICES=$GPU \
  python -u run.py \
    --is_training 1 \
    --root_path $root/ETT-small/ \
    --data_path $data_name.csv \
    --model_id $data_name_$seq_len_$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --factor 3 \
    --enc_in 7 \
    --dec_in 7 \
    --c_in 7 \
    --c_out 7 \
    --t_layer 3 \
    --des 'Exp' \
    --d_model 128 \
    --d_ff 128 \
    --steps_per_day 24 \
    --learning_rate 0.0005 \
    --train_epochs 10 \
    --patience 3 \
    --time_type 'abs' \
    --itr 1 >logs/LongForecasting/IndexNet/$data_name'_'$model_name'_'$pred_len.logs
done

data_name=ETTh2
for pred_len in 96 192 336 720
do
  CUDA_VISIBLE_DEVICES=$GPU \
  python -u run.py \
    --is_training 1 \
    --root_path $root/ETT-small/ \
    --data_path $data_name.csv \
    --model_id $data_name_$seq_len_$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --factor 3 \
    --enc_in 7 \
    --dec_in 7 \
    --c_in 7 \
    --c_out 7 \
    --t_layer 2 \
    --des 'Exp' \
    --d_model 256 \
    --d_ff 256 \
    --learning_rate 0.0001 \
    --batch_size 16 \
    --steps_per_day 24 \
    --time_type 'abs' \
    --itr 1 >logs/LongForecasting/IndexNet/$data_name'_'$model_name'_'$pred_len.logs
done

data_name=ETTm1
for pred_len in 96 192 336 720
do
  CUDA_VISIBLE_DEVICES=$GPU \
  python -u run.py \
    --is_training 1 \
    --root_path $root/ETT-small/ \
    --data_path $data_name.csv \
    --model_id $data_name_$seq_len_$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --factor 3 \
    --enc_in 7 \
    --dec_in 7 \
    --c_in 7 \
    --c_out 7 \
    --t_layer 3 \
    --des 'Exp' \
    --d_model 128 \
    --d_ff 128 \
    --lradj 'TST' \
    --learning_rate 0.0002 \
    --train_epochs 50 \
    --pct_start 0.2 \
    --patience 5 \
    --batch_size 16 \
    --minute 15 \
    --steps_per_day 96 \
    --time_type 'abs' \
    --itr 1 >logs/LongForecasting/IndexNet/$data_name'_'$model_name'_'$pred_len.logs
done

data_name=ETTm2
for pred_len in 96 192 336 720
do
  CUDA_VISIBLE_DEVICES=$GPU \
  python -u run.py \
    --is_training 1 \
    --root_path $root/ETT-small/ \
    --data_path $data_name.csv \
    --model_id $data_name_$seq_len_$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --d_layers 1 \
    --factor 3 \
    --enc_in 7 \
    --dec_in 7 \
    --c_in 7 \
    --c_out 7 \
    --t_layers 3 \
    --des 'Exp' \
    --d_model 128  \
    --d_ff 128 \
    --learning_rate 0.0002 \
    --batch_size 16 \
    --minute 15 \
    --steps_per_day 96 \
    --time_type 'abs' \
    --itr 1 >logs/LongForecasting/IndexNet/$data_name'_'$model_name'_'$pred_len.logs
done

data_name=Solar
for pred_len in 96 192 336 720
do
  CUDA_VISIBLE_DEVICES=$GPU \
  python -u run.py \
    --is_training 1 \
    --root_path $root/Solar/ \
    --data_path solar_AL.txt \
    --model_id solar_96_96 \
    --model $model_name \
    --data Solar \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --enc_in 137 \
    --dec_in 137 \
    --c_in 137 \
    --t_layers 2 \
    --c_out 137 \
    --des 'Exp' \
    --d_model 512 \
    --d_ff 512 \
    --learning_rate 0.0005 \
    --train_epochs 30 \
    --patience 5 \
    --steps_per_day 144 \
    --time_type 'rlt' \
    --itr 1 >logs/LongForecasting/IndexNet/$data_name'_'$model_name'_'$pred_len.logs
done

root=./dataset/PEMS
data_name=PEMS

for pred_len in 12; do
  CUDA_VISIBLE_DEVICES=$GPU \
  python -u run.py \
    --is_training 1 \
    --root_path $root \
    --data_path PEMS03.npz \
    --model_id $data_name \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --enc_in 358 \
    --dec_in 358 \
    --c_in 358 \
    --c_out 358 \
    --des 'Exp' \
    --itr 1 \
    --d_model 512 \
    --d_ff 512 \
    --batch_size 16 \
    --learning_rate 0.001 \
    --steps_per_day 288 \
    --revin \
    --time_type 'rlt' \
    --t_layers 3 >logs/LongForecasting/IndexNet/$data_name'03_'$model_name'_'$pred_len.log
done

for pred_len in 12; do
  CUDA_VISIBLE_DEVICES=$GPU \
  python -u run.py \
    --is_training 1 \
    --root_path $root \
    --data_path PEMS04.npz \
    --model_id $data_name \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --enc_in 307 \
    --dec_in 307 \
    --c_in 307 \
    --c_out 307 \
    --des 'Exp' \
    --itr 1 \
    --d_model 512 \
    --d_ff 512 \
    --batch_size 16 \
    --learning_rate 0.001 \
    --steps_per_day 288 \
    --revin \
    --time_type 'rlt' \
    --t_layers 3 >logs/LongForecasting/IndexNet/$data_name'04_'$model_name'_'$pred_len.log
done

for pred_len in 12; do
  CUDA_VISIBLE_DEVICES=$GPU \
  python -u run.py \
    --is_training 1 \
    --root_path $root \
    --data_path PEMS07.npz \
    --model_id $data_name \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --enc_in 883 \
    --dec_in 883 \
    --c_in 883 \
    --c_out 883 \
    --des 'Exp' \
    --itr 1 \
    --d_model 512 \
    --d_ff 512 \
    --batch_size 16 \
    --learning_rate 0.001 \
    --steps_per_day 288 \
    --revin \
    --time_type 'rlt' \
    --t_layers 3 >logs/LongForecasting/IndexNet/$data_name'07_'$model_name'_'$pred_len.log
done

for pred_len in 12; do
  CUDA_VISIBLE_DEVICES=$GPU \
  python -u run.py \
    --is_training 1 \
    --root_path $root \
    --data_path PEMS08.npz \
    --model_id $data_name \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --enc_in 170 \
    --dec_in 170 \
    --c_in 170 \
    --c_out 170 \
    --des 'Exp' \
    --itr 1 \
    --d_model 512 \
    --d_ff 512 \
    --batch_size 16 \
    --learning_rate 0.001 \
    --steps_per_day 288 \
    --revin \
    --time_type 'rlt' \
    --t_layers 3 >logs/LongForecasting/IndexNet/$data_name'08_'$model_name'_'$pred_len.log
done