#!/bin/bash
cd ..
python train_net.py \
  --wandb_entity "entity" \
  --wandb_proj_name "proj" \
  --data_root "data" \
  --device "cuda" \
  --dataset "cifar10" \
  --batch_size 64 \
  --agop_batch_size 32 \
  --agop_log_freq 10 \
  --epochs 201 \
  --n_hid_layers 3 \
  --hidden_width 1024 \
  --init_scale 1.0 \
  --act_fn "relu" \
  --opt "sgd" \
  --momentum 0.9 \
  --loss "mse" \
  --learning_rate 1e-1 \
  --weight_decay 1e-4 \
  --scheduler "cosine"
