#!/bin/bash
cd ..
python train_net.py \
  --wandb_entity "entity" \
  --wandb_proj_name "proj" \
  --data_root "data" \
  --device "cuda" \
  --dataset "modular_arithmetic" \
  --operation "x+y" \
  --prime 97 \
  --training_fraction 0.15 \
  --agop_batch_size 32 \
  --agop_log_freq 50 \
  --epochs 1001 \
  --batch_size 32 \
  --n_hid_layers 1 \
  --hidden_width 1024 \
  --init_scale 1.0 \
  --act_fn "relu" \
  --opt "adamw" \
  --momentum 0.0 \
  --loss "mse" \
  --learning_rate 1e-2 \
  --weight_decay 1.0 \
  --scheduler "cosine"
