#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
核心接口模块
定义项目中的主要接口和抽象类
"""

from .knowledge_graph_interfaces import (
    IKnowledgeGraphRetriever,
    IKnowledgeGraphExporter,
    INodeRetriever,
    NodeInfo,
    GraphStats
)

from .implicit_interfaces import (
    IImplicitGenerator,
    IImplicitEvaluator,
    ImplicitMethod,
    ImplicitRequest,
    ImplicitPrompt
)

from .asr_interfaces import (
    IASREvaluator,
    IConstraintChecker,
    ASRResult
)

from .fluency_interfaces import (
    IFluencyEvaluator,
    FluencyResult
)

__all__ = [
    'IKnowledgeGraphRetriever',
    'IKnowledgeGraphExporter',
    'INodeRetriever',
    'NodeInfo',
    'GraphStats',
    'IImplicitGenerator',
    'IImplicitEvaluator',
    'ImplicitMethod',
    'ImplicitRequest',
    'ImplicitPrompt',
    'IASREvaluator',
    'IConstraintChecker',
    'ASRResult',
    'IFluencyEvaluator',
    'FluencyResult'
]
