#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
流畅度评估相关接口定义
"""

from abc import ABC, abstractmethod
from typing import List, Optional
from dataclasses import dataclass


@dataclass
class FluencyResult:
    """流畅度评估结果"""
    text: str
    perplexity_score: float
    is_fluent: bool
    fluency_score: float  # 0-1分数
    evaluation_method: str = "ppl_only"
    error_message: Optional[str] = None


class IFluencyEvaluator(ABC):
    """流畅度评估器接口"""
    
    @abstractmethod
    def evaluate_fluency(self, text: str) -> FluencyResult:
        """评估单个文本的流畅度"""
        pass
    
    @abstractmethod
    def batch_evaluate_fluency(self, texts: List[str]) -> List[FluencyResult]:
        """批量评估文本流畅度"""
        pass
