#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
核心模块包
包含知识图谱检索、有害提示词生成和毒性评估等核心功能
"""

# 导入核心模块
try:
    from .wikidata_retriever import WikidataRetriever
except ImportError:
    WikidataRetriever = None

try:
    from .harmful_prompt_generator import HarmfulPromptGenerator, HarmCategory, HarmPrompt
except ImportError:
    HarmfulPromptGenerator = None
    HarmCategory = None
    HarmPrompt = None

try:
    from .granite_guardian_evaluator import GraniteGuardianEvaluator, ToxicityResult
except ImportError:
    GraniteGuardianEvaluator = None
    ToxicityResult = None

# 导出列表
__all__ = []

# 动态添加成功导入的模块
if WikidataRetriever is not None:
    __all__.append('WikidataRetriever')
if HarmfulPromptGenerator is not None:
    __all__.extend(['HarmfulPromptGenerator', 'HarmCategory', 'HarmPrompt'])
if GraniteGuardianEvaluator is not None:
    __all__.extend(['GraniteGuardianEvaluator', 'ToxicityResult'])
