from pathlib import Path
import hydra
from omegaconf import OmegaConf, open_dict

from ltsgns_mp.envs import Env
from ltsgns_mp.util.initialization import main_initialization
from ltsgns_mp.util.own_types import ConfigDict
from ltsgns_mp.util.util import load_omega_conf_resolvers
from scripts.evaluation.evaluate_model import Evaluator


@hydra.main(version_base=None, config_path="../../configs", config_name="visualization_config")
def evaluate_main(config: ConfigDict) -> None:
    evaluator = Evaluator(evaluation_config=config)
    evaluator.evaluate_experiment()


if __name__ == '__main__':
    # register OmegaConf resolver for hydra
    load_omega_conf_resolvers()
    evaluate_main()
