from ltsgns_mp.algorithms.lnpdfs.ltsgns_mp_lnpdf import LTSGNS_MP_LNPDF
from ltsgns_mp.algorithms.lnpdfs.ltsgns_step_lnpdf import LTSGNS_Step_LNPDF


def get_lnpdf(lnpdf_config, batch, simulator, prior):
    if lnpdf_config.name == "ltsgns_mp_lnpdf":
        return LTSGNS_MP_LNPDF(lnpdf_config, batch, simulator, prior)
    elif lnpdf_config.name == "ltsgns_step_lnpdf":
        return LTSGNS_Step_LNPDF(lnpdf_config, batch, simulator, prior)
    else:
        raise NotImplementedError(f"Unknown lnpdf name: {lnpdf_config.name}")
