from lts_gns.algorithms.abstract_algorithm import AbstractAlgorithm
from lts_gns.recording.loggers.abstract_logger import AbstractLogger
from lts_gns.util.own_types import *


class NetworkSummaryLogger(AbstractLogger):
    """
    A very basic logger that prints the config file as an output at the start of the experiment. Also saves the config
    as a .yaml in the experiment's directory.
    """

    def log_iteration(self, recorded_values: ValueDict, iteration: int) -> None:
        if iteration == 0:
            assert isinstance(self._algorithm, AbstractAlgorithm), f"Algorithm must be some GNS, " \
                                                             f"provided {type(self._algorithm)} " \
                                                             f"instead"
            self._writer.info("Started NetworkSummaryLogger.")

    def finalize(self) -> None:
        pass
