import dash
from dash import dcc
from dash import html
from dash.dependencies import Input, Output


def show_figure_in_dash(fig):
    app = dash.Dash()
    app.layout = html.Div([
        html.Div(id="output"),  # use to print current relayout values
        dcc.Graph(id="fig", figure=fig)
    ])

    @app.callback(
        Output("output", "children"),
        Input("fig", "relayoutData")
    )
    def show_data(data):
        # show camera settings like eye upon change
        return [str(data)]

    app.run_server(debug=False, use_reloader=False)
