# GLANCE: Global Actions in a Nutshell for Counterfactual Explainability

This is the home directory of our framework GLANCE. Before trying to run our project, please consult the setup instructions given below.

## Setup Instructions

Make sure python and pip are installed. Preferable, create a virtual environment and activate it. Then, use the file `requirements.txt` to install all dependencies of our framework:

```shell
$ pip install -r requirements.txt
```

## Example Notebooks

As a gateway for the user, there exist 4 example notebooks in the `examples/` directory:
- COMPAS.ipynb
- DefaultCredit.ipynb
- GermanCredit.ipynb
- HELOC.ipynb

Having successfully complete the setup, the scripts should be able to run as-is. They demonstrate basic usage of our framework and the user can play with the values of some parameters.

**Note**: To avoid confusion, we should point out that the classes encapsulating the functionality of our two algorithms `C-GLANCE` and `T-GLANCE` are called `IterativeMerges` and `CounterfactualTree`, respectively. This is due to an earlier naming of the two algorithms.

## Other files of interest

For the interested user, our source code lives in the `src/` directory, while in the `examples/` directory we also have a python script named `script.py`, and which is the one we used to produce the results reported in our paper.

The script comes with some help text, so simply run `python script.py --help` to see it.

The script also requires an input file in json form, with one field that resembles a `scikit-learn` parameter grid. This is how we tell the script for which combinations of parameters to run our framework. For better understanding, check the template file `examples/param_grid.json`.
