/*
 * Decompiled with CFR 0.152.
 */
package language.runtime.runners;

import java.io.Serializable;
import language.model.ActionRequestDef;
import language.model.Param;
import language.model.ParamList;
import language.model.ParamSig;
import language.model.ParamSigList;
import language.model.PredicateDef;
import language.model.PredicateRef;
import language.model.RuleDef;
import language.runtime.runners.ActionRunner;
import language.runtime.runners.PredicateRunner;
import language.runtime.runners.PredicateRunner$;
import language.runtime.runners.RuleRunner$;
import language.struct.ChangeLog;
import language.struct.DynamicValue;
import language.struct.EnvObject;
import language.struct.ParamIterator;
import language.struct.RuleChangeLog;
import language.struct.ScopedVariableLUT;
import language.struct.Taxonomy;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.sys.package$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001\u0002\u0011\"\u0001!B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\tu\u0001\u0011\t\u0011)A\u0005c!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003>\u0011!\u0011\u0005A!b\u0001\n\u0003\u0019\u0005\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u000b!\u0003A\u0011A%\t\u000f9\u0003!\u0019!C\u0001\u001f\"1q\r\u0001Q\u0001\nACq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011\u000e\u0003\u0004o\u0001\u0001\u0006IA\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0001q\u0011\u0019!\b\u0001)A\u0005c\"9Q\u000f\u0001b\u0001\n\u00031\bBB>\u0001A\u0003%q\u000fC\u0004}\u0001\t\u0007I\u0011A?\t\u000f\u0005\r\u0001\u0001)A\u0005}\"I\u0011Q\u0001\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\n!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003O\u0002A\u0011AA5\u0011\u001d\t9\u0007\u0001C\u0001\u0003oBq!a\u001a\u0001\t\u0003\t\u0019\tC\u0004\u0002\"\u0002!\t!a)\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002$\u001e9\u0011qU\u0011\t\u0002\u0005%fA\u0002\u0011\"\u0011\u0003\tY\u000b\u0003\u0004I9\u0011\u0005\u0011Q\u0016\u0005\b\u0003_cB\u0011AAY\u0011%\tI\fHI\u0001\n\u0003\tYL\u0001\u0006Sk2,'+\u001e8oKJT!AI\u0012\u0002\u000fI,hN\\3sg*\u0011A%J\u0001\beVtG/[7f\u0015\u00051\u0013\u0001\u00037b]\u001e,\u0018mZ3\u0004\u0001M\u0011\u0001!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\u000bI,H.Z:\u0016\u0003E\u00022A\u000b\u001a5\u0013\t\u00194FA\u0003BeJ\f\u0017\u0010\u0005\u00026q5\taG\u0003\u00028K\u0005)Qn\u001c3fY&\u0011\u0011H\u000e\u0002\b%VdW\rR3g\u0003\u0019\u0011X\u000f\\3tA\u0005y\u0001O]3eS\u000e\fG/\u001a*v]:,'/F\u0001>!\tqt(D\u0001\"\u0013\t\u0001\u0015EA\bQe\u0016$\u0017nY1uKJ+hN\\3s\u0003A\u0001(/\u001a3jG\u0006$XMU;o]\u0016\u0014\b%A\u0006eK\n,xmT;uaV$X#\u0001#\u0011\u0005)*\u0015B\u0001$,\u0005\u001d\u0011un\u001c7fC:\fA\u0002Z3ck\u001e|U\u000f\u001e9vi\u0002\na\u0001P5oSRtD\u0003\u0002&L\u00196\u0003\"A\u0010\u0001\t\u000b=:\u0001\u0019A\u0019\t\u000bm:\u0001\u0019A\u001f\t\u000f\t;\u0001\u0013!a\u0001\t\u0006QqN\u00196t\u0005f$\u0016\u0010]3\u0016\u0003A\u0003B!\u0015-\\=:\u0011!K\u0016\t\u0003'.j\u0011\u0001\u0016\u0006\u0003+\u001e\na\u0001\u0010:p_Rt\u0014BA,,\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011L\u0017\u0002\u0004\u001b\u0006\u0004(BA,,!\t\tF,\u0003\u0002^5\n11\u000b\u001e:j]\u001e\u00042!U0b\u0013\t\u0001'LA\u0002TKR\u0004\"AY3\u000e\u0003\rT!\u0001Z\u0013\u0002\rM$(/^2u\u0013\t17MA\u0005F]Z|%M[3di\u0006YqN\u00196t\u0005f$\u0016\u0010]3!\u00031\u0001(/\u001a3jG\u0006$X\rT+U+\u0005Q\u0007\u0003B)Y7.\u0004\"!\u000e7\n\u000554$\u0001\u0004)sK\u0012L7-\u0019;f\t\u00164\u0017!\u00049sK\u0012L7-\u0019;f\u0019V#\u0006%\u0001\u0007bGRLwN\u001c*v]:,'/F\u0001r!\tq$/\u0003\u0002tC\ta\u0011i\u0019;j_:\u0014VO\u001c8fe\u0006i\u0011m\u0019;j_:\u0014VO\u001c8fe\u0002\n\u0011\"Y2uS>tG*\u0016+\u0016\u0003]\u0004B!\u0015-\\qB\u0011Q'_\u0005\u0003uZ\u0012\u0001#Q2uS>t'+Z9vKN$H)\u001a4\u0002\u0015\u0005\u001cG/[8o\u0019V#\u0006%\u0001\u0005uCb|gn\\7z+\u0005q\bC\u00012\u0000\u0013\r\t\ta\u0019\u0002\t)\u0006DxN\\8ns\u0006IA/\u0019=p]>l\u0017\u0010I\u0001\u000eeVdWm\u00115b]\u001e,Gj\\4\u0016\u0005\u0005%\u0001CBA\u0006\u0003+\tI\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u001diW\u000f^1cY\u0016T1!a\u0005,\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003/\tiAA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bc\u00012\u0002\u001c%\u0019\u0011QD2\u0003\u001bI+H.Z\"iC:<W\rT8h\u00039\u0011X\u000f\\3DQ\u0006tw-\u001a'pO\u0002\nA\"\u001a<bYV\fG/\u001a*vY\u0016$B!!\u0007\u0002&!1\u0011q\u0005\u000bA\u0002Q\nAA];mK\u0006\u0001\"/\u001e8Q_N$8m\u001c8eSRLwN\u001c\u000b\u000b\u0003[\t)$a\u000e\u0002T\u0005\u0005\u0004\u0003\u0002\u00163\u0003_\u00012AYA\u0019\u0013\r\t\u0019d\u0019\u0002\n\u0007\"\fgnZ3M_\u001eDa!a\n\u0016\u0001\u0004!\u0004bBA\u001d+\u0001\u0007\u00111H\u0001\u000fa>\u001cHoY8oI&$\u0018n\u001c8t!\u0019\ti$a\u0012\u0002N9!\u0011qHA\"\u001d\r\u0019\u0016\u0011I\u0005\u0002Y%\u0019\u0011QI\u0016\u0002\u000fA\f7m[1hK&!\u0011\u0011JA&\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\u00153\u0006E\u00026\u0003\u001fJ1!!\u00157\u00051\u0001&/\u001a3jG\u0006$XMU3g\u0011\u001d\t)&\u0006a\u0001\u0003/\nqB^1s\u001d\u0006lW\rV8JIbdU\u000b\u0016\t\b\u0003\u0017\tIfWA.\u0013\rI\u0016Q\u0002\t\u0004U\u0005u\u0013bAA0W\t\u0019\u0011J\u001c;\t\u000f\u0005\rT\u00031\u0001\u0002f\u0005Y\u0011m]:jO:lWM\u001c;t!\rQ#'Y\u0001\nO\u0016$8*Z=TiJ$\u0012bWA6\u0003_\n\u0019(!\u001e\t\u000f\u00055d\u00031\u0001\u0002N\u00059\u0001O]3e%\u00164\u0007BBA9-\u0001\u00071.A\u0005qe\u0016$\u0017nY1uK\"9\u0011Q\u000b\fA\u0002\u0005]\u0003bBA2-\u0001\u0007\u0011Q\r\u000b\n7\u0006e\u00141PA@\u0003\u0003Cq!!\u001c\u0018\u0001\u0004\ti\u0005\u0003\u0004\u0002~]\u0001\r\u0001_\u0001\u0007C\u000e$\u0018n\u001c8\t\u000f\u0005Us\u00031\u0001\u0002X!9\u00111M\fA\u0002\u0005\u0015DcC.\u0002\u0006\u0006%\u00151SAO\u0003?Ca!a\"\u0019\u0001\u0004Y\u0016\u0001\u00028b[\u0016Dq!a#\u0019\u0001\u0004\ti)A\u0005qCJ\fW\u000eT5tiB\u0019Q'a$\n\u0007\u0005EeGA\u0005QCJ\fW\u000eT5ti\"9\u0011Q\u0013\rA\u0002\u0005]\u0015\u0001\u00049be\u0006l7+[4MSN$\bcA\u001b\u0002\u001a&\u0019\u00111\u0014\u001c\u0003\u0019A\u000b'/Y7TS\u001ed\u0015n\u001d;\t\u000f\u0005U\u0003\u00041\u0001\u0002X!9\u00111\r\rA\u0002\u0005\u0015\u0014!\u0005;p'R\u0014\u0018N\\4DQ\u0006tw-\u001a'pOR\t1,A\bu_\"#V\nT\"iC:<W\rT8h\u0003)\u0011V\u000f\\3Sk:tWM\u001d\t\u0003}q\u0019\"\u0001H\u0015\u0015\u0005\u0005%\u0016AD7l!J,G-[2bi\u0016dU\u000b\u0016\u000b\u0004U\u0006M\u0006bBA[=\u0001\u0007\u0011qW\u0001\u000baJ,G-[2bi\u0016\u001c\bc\u0001\u00163W\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!!0+\u0007\u0011\u000byl\u000b\u0002\u0002BB!\u00111YAg\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017!C;oG\",7m[3e\u0015\r\tYmK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAh\u0003\u000b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class RuleRunner {
    private final RuleDef[] rules;
    private final PredicateRunner predicateRunner;
    private final boolean debugOutput;
    private final Map<String, Set<EnvObject>> objsByType;
    private final Map<String, PredicateDef> predicateLUT;
    private final ActionRunner actionRunner;
    private final Map<String, ActionRequestDef> actionLUT;
    private final Taxonomy taxonomy;
    private final ArrayBuffer<RuleChangeLog> ruleChangeLog;

    public static boolean $lessinit$greater$default$3() {
        return RuleRunner$.MODULE$.$lessinit$greater$default$3();
    }

    public static Map<String, PredicateDef> mkPredicateLUT(PredicateDef[] predicateDefArray) {
        return RuleRunner$.MODULE$.mkPredicateLUT(predicateDefArray);
    }

    public RuleDef[] rules() {
        return this.rules;
    }

    public PredicateRunner predicateRunner() {
        return this.predicateRunner;
    }

    public boolean debugOutput() {
        return this.debugOutput;
    }

    public Map<String, Set<EnvObject>> objsByType() {
        return this.objsByType;
    }

    public Map<String, PredicateDef> predicateLUT() {
        return this.predicateLUT;
    }

    public ActionRunner actionRunner() {
        return this.actionRunner;
    }

    public Map<String, ActionRequestDef> actionLUT() {
        return this.actionLUT;
    }

    public Taxonomy taxonomy() {
        return this.taxonomy;
    }

    public ArrayBuffer<RuleChangeLog> ruleChangeLog() {
        return this.ruleChangeLog;
    }

    public RuleChangeLog evaluateRule(RuleDef rule) {
        int numPreconditions = rule.preconditions().length();
        scala.collection.mutable.Map varTypesMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        ArrayBuffer changeLog = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPreconditions).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)precondIdx -> {
            PredicateRef precond = rule.preconditions().apply(precondIdx);
            String predicateName = precond.name();
            if (!this.predicateLUT().contains(predicateName) && !this.actionLUT().contains(predicateName)) {
                String errStr = new java.lang.StringBuilder(79).append("ERROR: Predicate named (").append(predicateName).append(") referenced by rule (").append(rule.name()).append(") cannot be found. (around line ").append(rule.pos().toString()).append(")").toString();
                Predef$.MODULE$.println(errStr);
                throw package$.MODULE$.exit(1);
            }
            ObjectRef<ParamSigList> paramSigList = ObjectRef.create(new ParamSigList((List<ParamSig>)List$.MODULE$.empty()));
            if (this.predicateLUT().contains(predicateName)) {
                PredicateDef predicate = (PredicateDef)this.predicateLUT().apply(predicateName);
                paramSigList.elem = predicate.paramSigList();
            } else if (this.actionLUT().contains(predicateName)) {
                ActionRequestDef action = (ActionRequestDef)this.actionLUT().apply(predicateName);
                paramSigList.elem = action.paramSigList();
            }
            precond.paramList().parameters().foreach((Function1<Param, Object> & Serializable & scala.Serializable)predParam -> {
                RuleRunner.$anonfun$evaluateRule$2(this, paramSigList, varTypesMap, rule, predParam);
                return BoxedUnit.UNIT;
            });
        });
        Tuple2[] flat = (Tuple2[])varTypesMap.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        String[] varNames = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])flat)).map((Function1<Tuple2, String> & Serializable & scala.Serializable)x$2 -> (String)x$2._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] varTypes = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])flat)).map((Function1<Tuple2, String> & Serializable & scala.Serializable)x$3 -> (String)x$3._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ArrayBuffer elems = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), varNames.length).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            ParamSig param2 = new ParamSig(varNames[i], varTypes[i]);
            elems.append(Predef$.MODULE$.wrapRefArray((Object[])new ParamSig[]{param2}));
        });
        ParamSigList paramSigList = new ParamSigList(elems.toList());
        scala.collection.mutable.Map varNameToIdxLUT = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), varNames.length).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> varNameToIdxLUT.update(varNames[i], BoxesRunTime.boxToInteger(i)));
        ParamIterator iter = new ParamIterator(paramSigList, this.objsByType());
        Breaks$.MODULE$.breakable((JFunction0$mcV$sp & scala.Serializable)() -> {
            while (true) {
                Option<EnvObject[]> combo;
                if ((combo = iter.next()).isEmpty()) {
                    throw Breaks$.MODULE$.break();
                }
                String[] strKeys = (String[])Array$.MODULE$.fill(numPreconditions, (Function0<String> & Serializable & scala.Serializable)() -> "", ClassTag$.MODULE$.apply(String.class));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPreconditions).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)precondIdx -> {
                    block1: {
                        String predicateName;
                        PredicateRef precond;
                        block0: {
                            precond = rule.preconditions().apply(precondIdx);
                            predicateName = precond.name();
                            if (!this.predicateLUT().contains(predicateName)) break block0;
                            PredicateDef predicate = (PredicateDef)this.predicateLUT().apply(predicateName);
                            strKeys$1[precondIdx] = this.getKeyStr(precond, predicate, (scala.collection.mutable.Map<String, Object>)varNameToIdxLUT, (EnvObject[])combo.get());
                            break block1;
                        }
                        if (!this.actionLUT().contains(predicateName)) break block1;
                        ActionRequestDef action = (ActionRequestDef)this.actionLUT().apply(predicateName);
                        strKeys$1[precondIdx] = this.getKeyStr(precond, action, (scala.collection.mutable.Map<String, Object>)varNameToIdxLUT, (EnvObject[])combo.get());
                    }
                });
                BooleanRef runPostcondition = BooleanRef.create(true);
                new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])strKeys)).foreach((Function1<String, Object> & Serializable & scala.Serializable)strKey -> {
                    RuleRunner.$anonfun$evaluateRule$11(this, runPostcondition, strKey);
                    return BoxedUnit.UNIT;
                });
                if (!runPostcondition.elem) continue;
                List<PredicateRef> postConditions = rule.postconditions();
                ChangeLog[] changes = this.runPostcondition(rule, rule.postconditions(), varNameToIdxLUT, combo.get());
                changeLog.insertAll(changeLog.length(), Predef$.MODULE$.wrapRefArray((Object[])changes));
            }
        });
        return new RuleChangeLog(rule, (ChangeLog[])changeLog.toArray(ClassTag$.MODULE$.apply(ChangeLog.class)));
    }

    public ChangeLog[] runPostcondition(RuleDef rule, List<PredicateRef> postconditions, scala.collection.mutable.Map<String, Object> varNameToIdxLUT, EnvObject[] assignments) {
        ArrayBuffer changeLog = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), postconditions.length()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)postCondIdx -> {
            PredicateRef postcond = (PredicateRef)postconditions.apply(postCondIdx);
            if (this.debugOutput()) {
                Predef$.MODULE$.println(new java.lang.StringBuilder(20).append("runPostcondition(): ").append(postcond.toString()).toString());
            }
            String predicateName = postcond.name();
            if (this.predicateLUT().contains(predicateName)) {
                PredicateDef predicate = (PredicateDef)this.predicateLUT().apply(predicateName);
                ScopedVariableLUT varLUT = new ScopedVariableLUT();
                ArrayBuffer errors = new ArrayBuffer();
                postcond.paramList().parameters().foreach((Function1<Param, Object> & Serializable & scala.Serializable)predParam -> {
                    RuleRunner.$anonfun$runPostcondition$2(this, predicate, assignments, varNameToIdxLUT, varLUT, rule, errors, predParam);
                    return BoxedUnit.UNIT;
                });
                if (errors.length() > 0) {
                    Predef$.MODULE$.println(errors.mkString("\n"));
                    throw package$.MODULE$.exit(1);
                }
                if (this.debugOutput()) {
                    Predef$.MODULE$.println(new java.lang.StringBuilder(11).append("Predicate: ").append(postcond.paramList().toString()).toString());
                    Predef$.MODULE$.println("* runPostCondition(): VarLUT: ");
                    Predef$.MODULE$.println(varLUT.toString());
                }
                ChangeLog[] changes = this.predicateRunner().runSetter(predicate, varLUT);
                changeLog.insertAll(changeLog.length(), Predef$.MODULE$.wrapRefArray((Object[])changes));
            } else if (this.actionLUT().contains(predicateName)) {
                Tuple2<Object, String> tuple2;
                String actionName = predicateName;
                ActionRequestDef action = (ActionRequestDef)this.actionLUT().apply(actionName);
                ScopedVariableLUT varLUT = new ScopedVariableLUT();
                postcond.paramList().parameters().foreach((Function1<Param, Object> & Serializable & scala.Serializable)predParam -> {
                    RuleRunner.$anonfun$runPostcondition$3(action, assignments, varNameToIdxLUT, varLUT, predParam);
                    return BoxedUnit.UNIT;
                });
                if (this.debugOutput()) {
                    Predef$.MODULE$.println(new java.lang.StringBuilder(8).append("Action: ").append(postcond.paramList().toString()).toString());
                    Predef$.MODULE$.println("* runPostCondition(): VarLUT: ");
                    Predef$.MODULE$.println(varLUT.toString());
                }
                if ((tuple2 = this.actionRunner().setActionRequest(actionName, varLUT)) == null) {
                    throw new MatchError(tuple2);
                }
                boolean success = tuple2._1$mcZ$sp();
                String errStr = tuple2._2();
                Tuple2<Boolean, String> tuple22 = new Tuple2<Boolean, String>(BoxesRunTime.boxToBoolean(success), errStr);
                Tuple2<Boolean, String> tuple23 = tuple22;
                boolean success2 = tuple23._1$mcZ$sp();
                String errStr2 = tuple23._2();
                if (!success2) {
                    Predef$.MODULE$.println(new java.lang.StringBuilder(67).append("ERROR: Unable to queue action request (").append(actionName).append(") in rule (").append(rule.name()).append(") postcondition:\n").append(errStr2).toString());
                    throw package$.MODULE$.exit(1);
                }
            }
        });
        return (ChangeLog[])changeLog.toArray(ClassTag$.MODULE$.apply(ChangeLog.class));
    }

    public String getKeyStr(PredicateRef predRef, PredicateDef predicate, scala.collection.mutable.Map<String, Object> varNameToIdxLUT, EnvObject[] assignments) {
        String name = predicate.name();
        ParamList paramList = predRef.paramList();
        ParamSigList paramSigList = predicate.paramSigList();
        return this.getKeyStr(name, paramList, paramSigList, varNameToIdxLUT, assignments);
    }

    public String getKeyStr(PredicateRef predRef, ActionRequestDef action, scala.collection.mutable.Map<String, Object> varNameToIdxLUT, EnvObject[] assignments) {
        String name = action.name();
        ParamList paramList = predRef.paramList();
        ParamSigList paramSigList = action.paramSigList();
        return this.getKeyStr(name, paramList, paramSigList, varNameToIdxLUT, assignments);
    }

    public String getKeyStr(String name, ParamList paramList, ParamSigList paramSigList, scala.collection.mutable.Map<String, Object> varNameToIdxLUT, EnvObject[] assignments) {
        scala.collection.mutable.Map assignmentLUT = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        paramList.parameters().foreach((Function1<Param, Object> & Serializable & scala.Serializable)predParam -> {
            RuleRunner.$anonfun$getKeyStr$1(varNameToIdxLUT, assignments, assignmentLUT, predParam);
            return BoxedUnit.UNIT;
        });
        int numParam = paramSigList.parameters().length();
        EnvObject[] argsOut = new EnvObject[numParam];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numParam).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            ParamSig param2 = paramSigList.parameters().apply(i);
            argsOut$1[i] = (EnvObject)assignmentLUT.apply(param2.name());
        });
        return PredicateRunner$.MODULE$.mkPredStr(name, argsOut);
    }

    public String toStringChangeLog() {
        StringBuilder os = new StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.ruleChangeLog().length()).foreach((Function1<Object, StringBuilder> & Serializable & scala.Serializable)ruleIdx -> os.append(new java.lang.StringBuilder(2).append(BoxesRunTime.unboxToInt(ruleIdx)).append(": ").append(this.ruleChangeLog().apply(BoxesRunTime.unboxToInt(ruleIdx)).toString()).toString()));
        return os.toString();
    }

    public String toHTMLChangeLog() {
        StringBuilder os = new StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.ruleChangeLog().length()).foreach((Function1<Object, StringBuilder> & Serializable & scala.Serializable)ruleIdx -> os.append(this.ruleChangeLog().apply(BoxesRunTime.unboxToInt(ruleIdx)).toHTML(((Object)BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(ruleIdx))).toString())));
        return os.toString();
    }

    public static final /* synthetic */ void $anonfun$new$1(RuleRunner $this, RuleDef rule) {
        if ($this.debugOutput()) {
            Predef$.MODULE$.println(new java.lang.StringBuilder(6).append("Rule: ").append(rule.toString()).toString());
        }
        RuleChangeLog changeLog = $this.evaluateRule(rule);
        $this.ruleChangeLog().append(Predef$.MODULE$.wrapRefArray((Object[])new RuleChangeLog[]{changeLog}));
    }

    public static final /* synthetic */ void $anonfun$evaluateRule$2(RuleRunner $this, ObjectRef paramSigList$1, scala.collection.mutable.Map varTypesMap$1, RuleDef rule$1, Param predParam) {
        String predVarName = predParam.name();
        String ruleVarName = predParam.value();
        String varType = ((ParamSigList)paramSigList$1.elem).getVarType(predVarName);
        if (varTypesMap$1.contains(ruleVarName)) {
            Breaks$.MODULE$.breakable((JFunction0$mcV$sp & scala.Serializable)() -> {
                Object v = varTypesMap$1.apply(ruleVarName);
                String string = varType;
                if (v == null ? string != null : !v.equals(string)) {
                    Tuple3<Object, String, String[]> tuple3 = $this.taxonomy().getHypernyms(varType);
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    boolean success = BoxesRunTime.unboxToBoolean(tuple3._1());
                    String errStrHyponym = tuple3._2();
                    String[] hypernyms = tuple3._3();
                    Tuple3<Boolean, String, String[]> tuple32 = new Tuple3<Boolean, String, String[]>(BoxesRunTime.boxToBoolean(success), errStrHyponym, hypernyms);
                    Tuple3<Boolean, String, String[]> tuple33 = tuple32;
                    boolean success2 = BoxesRunTime.unboxToBoolean(tuple33._1());
                    String errStrHyponym2 = tuple33._2();
                    String[] hypernyms2 = tuple33._3();
                    if (success2 && new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])hypernyms2)).contains(varTypesMap$1.apply(ruleVarName))) {
                        throw Breaks$.MODULE$.break();
                    }
                    String errStr = new java.lang.StringBuilder(81).append("ERROR: Variable (").append(ruleVarName).append(") referenced by rule (").append(rule$1.name()).append(") has different types (").append(varTypesMap$1.apply(ruleVarName)).append(", ").append(varType).append("). (around line ").append(rule$1.pos().toString()).append(")").toString();
                    Predef$.MODULE$.println(errStr);
                    throw package$.MODULE$.exit(1);
                }
            });
        } else {
            varTypesMap$1.update(ruleVarName, varType);
        }
    }

    public static final /* synthetic */ void $anonfun$evaluateRule$11(RuleRunner $this, BooleanRef runPostcondition$1, String strKey) {
        block0: {
            boolean result = $this.predicateRunner().getResult(strKey);
            if (result) break block0;
            runPostcondition$1.elem = false;
        }
    }

    public static final /* synthetic */ void $anonfun$runPostcondition$2(RuleRunner $this, PredicateDef predicate$1, EnvObject[] assignments$1, scala.collection.mutable.Map varNameToIdxLUT$2, ScopedVariableLUT varLUT$1, RuleDef rule$2, ArrayBuffer errors$1, Param predParam) {
        block2: {
            String predVarName = predParam.name();
            String ruleVarName = predParam.value();
            String varType = predicate$1.getVarType(predVarName);
            EnvObject objArg = assignments$1[BoxesRunTime.unboxToInt(varNameToIdxLUT$2.apply(ruleVarName))];
            varLUT$1.set(predVarName, new DynamicValue(objArg));
            Tuple3<Object, String, String[]> tuple3 = $this.taxonomy().getHypernyms(objArg.getType());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            boolean successHyp = BoxesRunTime.unboxToBoolean(tuple3._1());
            String errStrHyp = tuple3._2();
            String[] hypernyms = tuple3._3();
            Tuple3<Boolean, String, String[]> tuple32 = new Tuple3<Boolean, String, String[]>(BoxesRunTime.boxToBoolean(successHyp), errStrHyp, hypernyms);
            Tuple3<Boolean, String, String[]> tuple33 = tuple32;
            boolean successHyp2 = BoxesRunTime.unboxToBoolean(tuple33._1());
            String errStrHyp2 = tuple33._2();
            String[] hypernyms2 = tuple33._3();
            if (!successHyp2) {
                Predef$.MODULE$.println(new java.lang.StringBuilder(79).append("ERROR: Unknown class type (").append(objArg.getType()).append(") when running predicate (").append(predicate$1.name()).append(") in rule (").append(rule$2.name()).append(") around line ").append(rule$2.pos().line()).append(".").toString());
                Predef$.MODULE$.println(errStrHyp2);
                throw package$.MODULE$.exit(1);
            }
            if (new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])hypernyms2)).contains(varType)) break block2;
            errors$1.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{new java.lang.StringBuilder(172).append("ERROR: In rule (").append(rule$2.name()).append("), predicate (").append(predicate$1.name()).append(") argument (").append(ruleVarName).append("): Expected type (").append(varType).append("), found type (").append(objArg.getType()).append("). \nThis error can happen when the preconditions have more generic types than the postconditions.").toString()}));
        }
    }

    public static final /* synthetic */ void $anonfun$runPostcondition$3(ActionRequestDef action$1, EnvObject[] assignments$1, scala.collection.mutable.Map varNameToIdxLUT$2, ScopedVariableLUT varLUT$2, Param predParam) {
        String predVarName = predParam.name();
        String ruleVarName = predParam.value();
        String varType = action$1.getVarType(predVarName);
        EnvObject objArg = assignments$1[BoxesRunTime.unboxToInt(varNameToIdxLUT$2.apply(ruleVarName))];
        varLUT$2.set(predVarName, new DynamicValue(objArg));
    }

    public static final /* synthetic */ void $anonfun$getKeyStr$1(scala.collection.mutable.Map varNameToIdxLUT$3, EnvObject[] assignments$2, scala.collection.mutable.Map assignmentLUT$1, Param predParam) {
        String predVarName = predParam.name();
        String ruleVarName = predParam.value();
        int varIdx = BoxesRunTime.unboxToInt(varNameToIdxLUT$3.apply(ruleVarName));
        EnvObject objAssignment = assignments$2[varIdx];
        assignmentLUT$1.update(predVarName, objAssignment);
    }

    public RuleRunner(RuleDef[] rules, PredicateRunner predicateRunner, boolean debugOutput) {
        this.rules = rules;
        this.predicateRunner = predicateRunner;
        this.debugOutput = debugOutput;
        this.objsByType = predicateRunner.objsByType();
        this.predicateLUT = RuleRunner$.MODULE$.mkPredicateLUT(predicateRunner.predicates());
        this.actionRunner = predicateRunner.actionRunner();
        this.actionLUT = this.actionRunner().actionLUT();
        this.taxonomy = predicateRunner.taxonomy();
        this.ruleChangeLog = new ArrayBuffer();
        if (debugOutput) {
            Predef$.MODULE$.println("RuleRunner(): Started...");
        }
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])rules)).foreach((Function1<RuleDef, Object> & Serializable & scala.Serializable)rule -> {
            RuleRunner.$anonfun$new$1(this, rule);
            return BoxedUnit.UNIT;
        });
    }
}

