/*
 * Decompiled with CFR 0.152.
 */
package scienceworld.objects.electricalcomponent;

import java.io.Serializable;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scienceworld.objects.electricalcomponent.Anode;
import scienceworld.objects.electricalcomponent.Cathode;
import scienceworld.objects.electricalcomponent.ElectricalComponent$;
import scienceworld.objects.electricalcomponent.Terminal;
import scienceworld.properties.DeviceProperties;
import scienceworld.properties.IsNotActivableDeviceOff;
import scienceworld.properties.MoveableProperties;
import scienceworld.struct.EnvObject;
import scienceworld.struct.EnvObject$;

@ScalaSignature(bytes="\u0006\u0001i3A\u0001D\u0007\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003B\u0002\u0013\u0001A\u0003%\u0011\u0005C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\t\r)\u0002\u0001\u0015!\u0003(\u0011\u0015Y\u0003\u0001\"\u0011-\u0011\u0015\u0019\u0004\u0001\"\u00115\u0011\u0015i\u0004\u0001\"\u0011?\u0011\u0015\u0011\u0005\u0001\"\u0011-\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0005q\u0001v\u000e\\1sSj,G-\u00127fGR\u0014\u0018nY1m\u0007>l\u0007o\u001c8f]RT!AD\b\u0002'\u0015dWm\u0019;sS\u000e\fGnY8na>tWM\u001c;\u000b\u0005A\t\u0012aB8cU\u0016\u001cGo\u001d\u0006\u0002%\u0005a1oY5f]\u000e,wo\u001c:mI\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\tA\u0012#\u0001\u0004tiJ,8\r^\u0005\u00035]\u0011\u0011\"\u00128w\u001f\nTWm\u0019;\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005i\u0011!B1o_\u0012,W#A\u0011\u0011\u0005y\u0011\u0013BA\u0012\u000e\u0005\u0015\ten\u001c3f\u0003\u0019\tgn\u001c3fA\u000591-\u0019;i_\u0012,W#A\u0014\u0011\u0005yA\u0013BA\u0015\u000e\u0005\u001d\u0019\u0015\r\u001e5pI\u0016\f\u0001bY1uQ>$W\rI\u0001\u0018SN,E.Z2ue&\u001c\u0017\r\u001c7z\u0007>tg.Z2uK\u0012$\u0012!\f\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\b\u0005>|G.Z1o\u0003i9W\r^(uQ\u0016\u0014X\t\\3diJL7-\u00197UKJl\u0017N\\1m)\t)4\bE\u0002/maJ!aN\u0018\u0003\r=\u0003H/[8o!\tq\u0012(\u0003\u0002;\u001b\tAA+\u001a:nS:\fG\u000eC\u0003=\u000f\u0001\u0007Q#\u0001\u0006uKJl\u0017N\\1m\u0013:\fQ\u0004Z5tG>tg.Z2u\u000b2,7\r\u001e:jG\u0006dG+\u001a:nS:\fGn\u001d\u000b\u0002\u007fA\u0011a\u0006Q\u0005\u0003\u0003>\u0012A!\u00168ji\u0006!A/[2l\u000319W\r\u001e*fM\u0016\u0014XM\u001c;t)\u0005)\u0005c\u0001$N!:\u0011qi\u0013\t\u0003\u0011>j\u0011!\u0013\u0006\u0003\u0015N\ta\u0001\u0010:p_Rt\u0014B\u0001'0\u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0004'\u0016$(B\u0001'0!\t1\u0015+\u0003\u0002S\u001f\n11\u000b\u001e:j]\u001e\fabZ3u\t\u0016\u001c8M]5qi&|g\u000e\u0006\u0002Q+\"9ak\u0003I\u0001\u0002\u00049\u0016\u0001B7pI\u0016\u0004\"A\f-\n\u0005e{#aA%oi\u0002")
public class PolarizedElectricalComponent
extends EnvObject {
    private final Anode anode;
    private final Cathode cathode;

    public Anode anode() {
        return this.anode;
    }

    public Cathode cathode() {
        return this.cathode;
    }

    @Override
    public boolean isElectricallyConnected() {
        if (this.anode().propElectricalConnection().get().size() > 0) {
            return true;
        }
        return this.cathode().propElectricalConnection().get().size() > 0;
    }

    @Override
    public Option<Terminal> getOtherElectricalTerminal(EnvObject terminalIn) {
        EnvObject envObject = terminalIn;
        Anode anode = this.anode();
        if (!(envObject != null ? !((Object)envObject).equals(anode) : anode != null)) {
            return new Some<Terminal>(this.cathode());
        }
        EnvObject envObject2 = terminalIn;
        Cathode cathode = this.cathode();
        if (!(envObject2 != null ? !((Object)envObject2).equals(cathode) : cathode != null)) {
            return new Some<Terminal>(this.anode());
        }
        return None$.MODULE$;
    }

    @Override
    public void disconnectElectricalTerminals() {
        this.anode().disconnect();
        this.cathode().disconnect();
    }

    @Override
    public boolean tick() {
        block1: {
            if (this.electricalRole() != ElectricalComponent$.MODULE$.ROLE_VOLTAGE_USER()) break block1;
            this.propDevice().get().isActivated_$eq(false);
            if (this.anode().connectsToGround(this.anode().connectsToGround$default$1()) && this.cathode().connectsToVoltage()) {
                this.anode().voltage_$eq(new Some<Object>(BoxesRunTime.boxToDouble(ElectricalComponent$.MODULE$.VOLTAGE_GENERATOR())));
                this.propDevice().get().isActivated_$eq(true);
            }
        }
        return super.tick();
    }

    @Override
    public Set<String> getReferents() {
        return (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"component", this.name(), this.getDescriptName(this.getDescriptName$default$1())}));
    }

    @Override
    public String getDescription(int mode) {
        Serializable serializable;
        StringBuilder os = new StringBuilder();
        os.append(new java.lang.StringBuilder(4).append("a ").append(this.getDescriptName(this.getDescriptName$default$1())).append(". ").toString());
        if (mode == EnvObject$.MODULE$.MODE_DETAILED()) {
            os.append(new java.lang.StringBuilder(29).append("its anode is connected to: ").append(this.anode().propElectricalConnection().get().getConnectedToStr()).append(". ").toString());
            serializable = os.append(new java.lang.StringBuilder(31).append("its cathode is connected to: ").append(this.cathode().propElectricalConnection().get().getConnectedToStr()).append(". ").toString());
        } else {
            serializable = BoxedUnit.UNIT;
        }
        return os.toString();
    }

    public PolarizedElectricalComponent() {
        super("", "", false);
        this.name_$eq("component");
        this.propDevice_$eq(new Some<DeviceProperties>(new IsNotActivableDeviceOff()));
        this.propMoveable_$eq(new Some<MoveableProperties>(new MoveableProperties(true)));
        this.anode = new Anode(this);
        this.cathode = new Cathode(this);
        this.addObject(this.anode());
        this.addObject(this.cathode());
        this.electricalRole_$eq(ElectricalComponent$.MODULE$.ROLE_VOLTAGE_USER());
    }
}

