/*
 * Decompiled with CFR 0.152.
 */
package py4j.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.Py4JException;
import py4j.reflection.LRUCache;
import py4j.reflection.MethodDescriptor;
import py4j.reflection.MethodInvoker;
import py4j.reflection.ReflectionUtil;
import py4j.reflection.TypeUtil;

public class ReflectionEngine {
    public static final int cacheSize = 100;
    private final Logger logger = Logger.getLogger(ReflectionEngine.class.getName());
    public static final Object RETURN_VOID = new Object();
    private static ThreadLocal<LRUCache<MethodDescriptor, MethodInvoker>> cacheHolder = new ThreadLocal<LRUCache<MethodDescriptor, MethodInvoker>>(){

        @Override
        protected LRUCache<MethodDescriptor, MethodInvoker> initialValue() {
            return new LRUCache<MethodDescriptor, MethodInvoker>(100);
        }
    };

    public Object createArray(String fqn, int[] dimensions) {
        Class<?> clazz = null;
        Object returnObject = null;
        try {
            clazz = TypeUtil.forName(fqn);
            returnObject = Array.newInstance(clazz, dimensions);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Class FQN does not exist: " + fqn, e);
            throw new Py4JException(e);
        }
        return returnObject;
    }

    private MethodInvoker getBestConstructor(List<Constructor<?>> acceptableConstructors, Class<?>[] parameters) {
        MethodInvoker lowestCost = null;
        for (Constructor<?> constructor : acceptableConstructors) {
            MethodInvoker temp = MethodInvoker.buildInvoker(constructor, parameters);
            int cost = temp.getCost();
            if (cost == -1) continue;
            if (cost == 0) {
                lowestCost = temp;
                break;
            }
            if (lowestCost != null && cost >= lowestCost.getCost()) continue;
            lowestCost = temp;
        }
        return lowestCost;
    }

    private MethodInvoker getBestMethod(List<Method> acceptableMethods, Class<?>[] parameters) {
        MethodInvoker lowestCost = null;
        for (Method method : acceptableMethods) {
            MethodInvoker temp = MethodInvoker.buildInvoker(method, parameters);
            int cost = temp.getCost();
            if (cost == -1) continue;
            if (cost == 0) {
                lowestCost = temp;
                break;
            }
            if (lowestCost != null && cost >= lowestCost.getCost()) continue;
            lowestCost = temp;
        }
        return lowestCost;
    }

    public Class<?> getClass(Class<?> clazz, String name) {
        Class<?> memberClass = null;
        try {
            for (Class<?> tempClass : clazz.getClasses()) {
                if (!tempClass.getSimpleName().equals(name)) continue;
                memberClass = tempClass;
                break;
            }
        }
        catch (Exception e) {
            memberClass = null;
        }
        return memberClass;
    }

    private Class<?>[] getClassParameters(Object[] parameters) {
        int size = parameters.length;
        Class[] classes = new Class[size];
        for (int i = 0; i < size; ++i) {
            classes[i] = parameters[i] == null ? null : parameters[i].getClass();
        }
        return classes;
    }

    public MethodInvoker getConstructor(Class<?> clazz, Class<?>[] parameters) {
        MethodDescriptor mDescriptor = new MethodDescriptor(clazz.getName(), clazz, parameters);
        MethodInvoker mInvoker = null;
        List<Constructor<?>> acceptableConstructors = null;
        LRUCache<MethodDescriptor, MethodInvoker> cache = cacheHolder.get();
        mInvoker = (MethodInvoker)cache.get(mDescriptor);
        if (mInvoker == null) {
            acceptableConstructors = this.getConstructorsByLength(clazz, parameters.length);
            mInvoker = acceptableConstructors.size() == 1 ? MethodInvoker.buildInvoker(acceptableConstructors.get(0), parameters) : this.getBestConstructor(acceptableConstructors, parameters);
            if (mInvoker != null && mInvoker.getCost() != -1) {
                cache.put(mDescriptor, mInvoker);
            } else {
                String errorMessage = "Constructor " + clazz.getName() + "(" + Arrays.toString(parameters) + ") does not exist";
                this.logger.log(Level.WARNING, errorMessage);
                throw new Py4JException(errorMessage);
            }
        }
        return mInvoker;
    }

    public MethodInvoker getConstructor(String classFQN, Object[] parameters) {
        Class<?> clazz = null;
        try {
            clazz = ReflectionUtil.classForName(classFQN);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Class FQN does not exist: " + classFQN, e);
            throw new Py4JException(e);
        }
        return this.getConstructor(clazz, this.getClassParameters(parameters));
    }

    private List<Constructor<?>> getConstructorsByLength(Class<?> clazz, int length) {
        ArrayList methods = new ArrayList();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != length) continue;
            methods.add(constructor);
        }
        return methods;
    }

    public Field getField(Class<?> clazz, String name) {
        Field field2 = null;
        try {
            field2 = clazz.getField(name);
            if (!Modifier.isPublic(field2.getModifiers()) && !field2.isAccessible()) {
                field2 = null;
            }
        }
        catch (NoSuchFieldException e) {
            field2 = null;
        }
        catch (Exception e) {
            field2 = null;
        }
        return field2;
    }

    public Field getField(Object obj, String name) {
        return this.getField(obj.getClass(), name);
    }

    public Field getField(String classFQN, String name) {
        Class<?> clazz = null;
        try {
            clazz = ReflectionUtil.classForName(classFQN);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Class FQN does not exist: " + classFQN, e);
            throw new Py4JException(e);
        }
        return this.getField(clazz, name);
    }

    public Object getFieldValue(Object obj, Field field2) {
        Object fieldValue = null;
        try {
            fieldValue = field2.get(obj);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error while fetching field value of " + field2, e);
            throw new Py4JException(e);
        }
        return fieldValue;
    }

    public Method getMethod(Class<?> clazz, String name) {
        Method m = null;
        try {
            for (Method tempMethod : clazz.getMethods()) {
                if (!tempMethod.getName().equals(name)) continue;
                m = tempMethod;
                break;
            }
        }
        catch (Exception e) {
            m = null;
        }
        return m;
    }

    public MethodInvoker getMethod(Class<?> clazz, String name, Class<?>[] parameters) {
        MethodDescriptor mDescriptor = new MethodDescriptor(name, clazz, parameters);
        MethodInvoker mInvoker = null;
        List<Method> acceptableMethods = null;
        LRUCache<MethodDescriptor, MethodInvoker> cache = cacheHolder.get();
        mInvoker = (MethodInvoker)cache.get(mDescriptor);
        if (mInvoker == null) {
            acceptableMethods = this.getMethodsByNameAndLength(clazz, name, parameters.length);
            mInvoker = acceptableMethods.size() == 1 ? MethodInvoker.buildInvoker(acceptableMethods.get(0), parameters) : this.getBestMethod(acceptableMethods, parameters);
            if (mInvoker != null && mInvoker.getCost() != -1) {
                cache.put(mDescriptor, mInvoker);
            } else {
                String errorMessage = "Method " + name + "(" + Arrays.toString(parameters) + ") does not exist";
                this.logger.log(Level.WARNING, errorMessage);
                throw new Py4JException(errorMessage);
            }
        }
        return mInvoker;
    }

    public MethodInvoker getMethod(Object object, String name, Object[] parameters) {
        return this.getMethod(object.getClass(), name, this.getClassParameters(parameters));
    }

    public MethodInvoker getMethod(String classFQN, String name, Object[] parameters) {
        Class<?> clazz = null;
        try {
            clazz = ReflectionUtil.classForName(classFQN);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Class FQN does not exist: " + classFQN, e);
            throw new Py4JException(e);
        }
        return this.getMethod(clazz, name, this.getClassParameters(parameters));
    }

    private List<Method> getMethodsByNameAndLength(Class<?> clazz, String name, int length) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name) || method.getParameterTypes().length != length) continue;
            methods.add(method);
        }
        return methods;
    }

    public Object invoke(Object object, MethodInvoker invoker, Object[] parameters) {
        Object returnObject = null;
        returnObject = invoker.invoke(object, parameters);
        if (invoker.isVoid()) {
            returnObject = RETURN_VOID;
        }
        return returnObject;
    }

    public void setFieldValue(Object obj, Field field2, Object value) {
        try {
            field2.set(obj, value);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error while setting field value of " + field2, e);
            throw new Py4JException(e);
        }
    }

    public String[] getPublicMethodNames(Object obj) {
        Method[] methods = obj.getClass().getMethods();
        HashSet<String> methodNames = new HashSet<String>();
        for (Method method : methods) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            methodNames.add(method.getName());
        }
        return methodNames.toArray(new String[methodNames.size()]);
    }

    public String[] getPublicFieldNames(Object obj) {
        Field[] fields = obj.getClass().getFields();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Field field2 : fields) {
            if (!Modifier.isPublic(field2.getModifiers())) continue;
            fieldNames.add(field2.getName());
        }
        return fieldNames.toArray(new String[fieldNames.size()]);
    }

    public String[] getPublicStaticFieldNames(Class<?> clazz) {
        Field[] fields = clazz.getFields();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Field field2 : fields) {
            if (!Modifier.isPublic(field2.getModifiers()) || !Modifier.isStatic(field2.getModifiers())) continue;
            fieldNames.add(field2.getName());
        }
        return fieldNames.toArray(new String[fieldNames.size()]);
    }

    public String[] getPublicStaticMethodNames(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        HashSet<String> methodNames = new HashSet<String>();
        for (Method method : methods) {
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
            methodNames.add(method.getName());
        }
        return methodNames.toArray(new String[methodNames.size()]);
    }

    public String[] getPublicStaticClassNames(Class<?> clazz) {
        Class<?>[] classes = clazz.getClasses();
        HashSet<String> classNames = new HashSet<String>();
        for (Class<?> clazz2 : classes) {
            if (!Modifier.isPublic(clazz2.getModifiers()) || !Modifier.isStatic(clazz2.getModifiers())) continue;
            classNames.add(clazz2.getSimpleName());
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    public String[] getPublicStaticNames(Class<?> clazz) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(Arrays.asList(this.getPublicStaticClassNames(clazz)));
        names.addAll(Arrays.asList(this.getPublicStaticFieldNames(clazz)));
        names.addAll(Arrays.asList(this.getPublicStaticMethodNames(clazz)));
        return names.toArray(new String[names.size()]);
    }
}

