/*
 * Decompiled with CFR 0.152.
 */
package scienceworld.objects.devices;

import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scienceworld.objects.devices.HeatSource;
import scienceworld.processes.Combustion$;
import scienceworld.properties.ContainerProperties;
import scienceworld.properties.DeviceProperties;
import scienceworld.properties.HeatSourceProperties;
import scienceworld.properties.HeatSourcePropertiesLighter;
import scienceworld.properties.IsNotContainer;
import scienceworld.properties.IsUsableNonActivable;
import scienceworld.properties.MaterialProperties;
import scienceworld.properties.MetalProp;
import scienceworld.properties.MoveableProperties;
import scienceworld.struct.EnvObject;

@ScalaSignature(bytes="\u0006\u0001\t3AAB\u0004\u0001\u001d!)1\u0003\u0001C\u0001)!)a\u0003\u0001C!/!)A\u0007\u0001C!k!)a\u0007\u0001C!o!)1\b\u0001C!y\t9A*[4ii\u0016\u0014(B\u0001\u0005\n\u0003\u001d!WM^5dKNT!AC\u0006\u0002\u000f=\u0014'.Z2ug*\tA\"\u0001\u0007tG&,gnY3x_JdGm\u0001\u0001\u0014\u0005\u0001y\u0001C\u0001\t\u0012\u001b\u00059\u0011B\u0001\n\b\u0005)AU-\u0019;T_V\u00148-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"\u0001\u0005\u0001\u0002\u000fU\u001cXmV5uQR\u0011\u0001\u0004\f\t\u00053qq\u0012%D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019!V\u000f\u001d7feA\u0011\u0011dH\u0005\u0003Ai\u0011qAQ8pY\u0016\fg\u000e\u0005\u0002#S9\u00111e\n\t\u0003Iii\u0011!\n\u0006\u0003M5\ta\u0001\u0010:p_Rt\u0014B\u0001\u0015\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011!f\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!R\u0002\"B\u0017\u0003\u0001\u0004q\u0013A\u00039bi&,g\u000e^(cUB\u0011qFM\u0007\u0002a)\u0011\u0011gC\u0001\u0007gR\u0014Xo\u0019;\n\u0005M\u0002$!C#om>\u0013'.Z2u\u0003\u0011!\u0018nY6\u0015\u0003y\tAbZ3u%\u00164WM]3oiN$\u0012\u0001\u000f\t\u0004Ee\n\u0013B\u0001\u001e,\u0005\r\u0019V\r^\u0001\u000fO\u0016$H)Z:de&\u0004H/[8o)\t\tS\bC\u0004?\u000bA\u0005\t\u0019A \u0002\t5|G-\u001a\t\u00033\u0001K!!\u0011\u000e\u0003\u0007%sG\u000f")
public class Lighter
extends HeatSource {
    @Override
    public Tuple2<Object, String> useWith(EnvObject patientObj) {
        double heatsourceTemp;
        if (patientObj.propMaterial().isEmpty()) {
            return new Tuple2<Object, String>(BoxesRunTime.boxToBoolean(true), "It's not clear how to use those items together.");
        }
        double combustionTemp = patientObj.propMaterial().get().combustionPoint();
        if (combustionTemp <= (heatsourceTemp = this.propHeatSource().get().maxTemp())) {
            Predef$.MODULE$.println("TODO: Combust");
            Tuple2<Object, String> tuple2 = Combustion$.MODULE$.setObjectOnFire(patientObj);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean success = tuple2._1$mcZ$sp();
            String messageStr = tuple2._2();
            Tuple2<Boolean, String> tuple22 = new Tuple2<Boolean, String>(BoxesRunTime.boxToBoolean(success), messageStr);
            Tuple2<Boolean, String> tuple23 = tuple22;
            boolean success2 = tuple23._1$mcZ$sp();
            String messageStr2 = tuple23._2();
            return new Tuple2<Object, String>(BoxesRunTime.boxToBoolean(true), messageStr2);
        }
        float heatAmount = 10.0f;
        double delta = heatsourceTemp - patientObj.propMaterial().get().temperatureC();
        if (delta > (double)heatAmount) {
            delta = heatAmount;
        }
        if (delta + patientObj.propMaterial().get().temperatureC() > heatsourceTemp) {
            delta = heatsourceTemp - patientObj.propMaterial().get().temperatureC();
        }
        if (delta < 0.0) {
            delta = 0.0;
        }
        MaterialProperties materialProperties = patientObj.propMaterial().get();
        materialProperties.temperatureC_$eq(materialProperties.temperatureC() + delta);
        return new Tuple2<Object, String>(BoxesRunTime.boxToBoolean(true), new StringBuilder(41).append("The lighter heats up the ").append(patientObj.name()).append(" a small amount.").toString());
    }

    @Override
    public boolean tick() {
        block2: {
            if (!this.propDevice().isDefined()) break block2;
            if (this.propDevice().get().isActivated()) {
                this.propHeatSource().get().setOnMax();
            } else {
                this.propHeatSource().get().setOff();
            }
        }
        return super.tick();
    }

    @Override
    public Set<String> getReferents() {
        return (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lighter", this.name(), this.getDescriptName(this.getDescriptName$default$1())}));
    }

    @Override
    public String getDescription(int mode) {
        scala.collection.mutable.StringBuilder os = new scala.collection.mutable.StringBuilder();
        os.append(new StringBuilder(2).append("a ").append(this.getDescriptName(this.getDescriptName$default$1())).toString());
        return os.toString();
    }

    public Lighter() {
        this.name_$eq("lighter");
        this.propHeatSource_$eq(new Some<HeatSourceProperties>(new HeatSourcePropertiesLighter()));
        this.propMaterial_$eq(new Some<MaterialProperties>(new MetalProp()));
        this.propContainer_$eq(new Some<ContainerProperties>(new IsNotContainer()));
        this.propDevice_$eq(new Some<DeviceProperties>(new IsUsableNonActivable()));
        this.propMoveable_$eq(new Some<MoveableProperties>(new MoveableProperties(true)));
    }
}

