/*
 * Decompiled with CFR 0.152.
 */
package scienceworld.processes;

import scala.Predef$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scienceworld.properties.MaterialProperties;
import scienceworld.struct.EnvObject;

public final class HeatTransfer$ {
    public static HeatTransfer$ MODULE$;
    private final double HEAT_TRANSFER_COEFFICIENT;
    private final float MAX_TRANSFER_PER_STEP;

    static {
        new HeatTransfer$();
    }

    public double HEAT_TRANSFER_COEFFICIENT() {
        return this.HEAT_TRANSFER_COEFFICIENT;
    }

    public float MAX_TRANSFER_PER_STEP() {
        return this.MAX_TRANSFER_PER_STEP;
    }

    public void heatTransferHeatSource(EnvObject heatSource, EnvObject heatedObj) {
        block2: {
            double objTemp;
            if (!heatSource.propDevice().isEmpty() && (!heatSource.propDevice().isDefined() || !heatSource.propDevice().get().isActivated()) || !heatSource.propHeatSource().get().curSetTemp().isDefined()) break block2;
            double heaterTemp = BoxesRunTime.unboxToDouble(heatSource.propHeatSource().get().curSetTemp().get());
            if (heatedObj.propMaterial().isDefined() && (objTemp = heatedObj.propMaterial().get().temperatureC()) < heaterTemp) {
                double deltaTemp = heaterTemp - objTemp;
                double increment = deltaTemp * this.HEAT_TRANSFER_COEFFICIENT();
                if (package$.MODULE$.abs(increment) > (double)this.MAX_TRANSFER_PER_STEP()) {
                    increment = this.MAX_TRANSFER_PER_STEP() * (float)RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(increment));
                }
                MaterialProperties materialProperties = heatedObj.propMaterial().get();
                materialProperties.temperatureC_$eq(materialProperties.temperatureC() + increment);
            }
        }
    }

    public void heatTransferCoolingSource(EnvObject coolingSource, EnvObject cooledObj) {
        block2: {
            double objTemp;
            if (!coolingSource.propDevice().isEmpty() && (!coolingSource.propDevice().isDefined() || !coolingSource.propDevice().get().isActivated()) || !coolingSource.propCoolingSource().get().curSetTemp().isDefined()) break block2;
            double coolerTemp = BoxesRunTime.unboxToDouble(coolingSource.propCoolingSource().get().curSetTemp().get());
            if (cooledObj.propMaterial().isDefined() && (objTemp = cooledObj.propMaterial().get().temperatureC()) > coolerTemp) {
                double deltaTemp = coolerTemp - objTemp;
                double increment = deltaTemp * this.HEAT_TRANSFER_COEFFICIENT();
                if (package$.MODULE$.abs(increment) > (double)this.MAX_TRANSFER_PER_STEP()) {
                    increment = this.MAX_TRANSFER_PER_STEP() * (float)RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(increment));
                }
                MaterialProperties materialProperties = cooledObj.propMaterial().get();
                materialProperties.temperatureC_$eq(materialProperties.temperatureC() + increment);
            }
        }
    }

    public void heatTransferTouchingObjects(EnvObject obj1, EnvObject obj2) {
        if (obj1.propMaterial().isEmpty() || obj2.propMaterial().isEmpty()) {
            return;
        }
        MaterialProperties obj1Prop = obj1.propMaterial().get();
        MaterialProperties obj2Prop = obj2.propMaterial().get();
        double obj1Temp = obj1Prop.temperatureC();
        double obj2Temp = obj2Prop.temperatureC();
        double minThermalConductivity = package$.MODULE$.min(obj1Prop.thermalConductivity(), obj2Prop.thermalConductivity());
        double delta1 = (obj2Prop.temperatureC() - obj1Prop.temperatureC()) * minThermalConductivity;
        double increment1 = delta1 * this.HEAT_TRANSFER_COEFFICIENT();
        if (package$.MODULE$.abs(increment1) > (double)this.MAX_TRANSFER_PER_STEP()) {
            increment1 = this.MAX_TRANSFER_PER_STEP() * (float)RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(increment1));
        }
        MaterialProperties materialProperties = obj1.propMaterial().get();
        materialProperties.temperatureC_$eq(materialProperties.temperatureC() + increment1);
        double delta2 = (obj1Prop.temperatureC() - obj2Prop.temperatureC()) * minThermalConductivity;
        double increment2 = delta2 * this.HEAT_TRANSFER_COEFFICIENT();
        if (package$.MODULE$.abs(increment2) > (double)this.MAX_TRANSFER_PER_STEP()) {
            increment2 = this.MAX_TRANSFER_PER_STEP() * (float)RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(increment2));
        }
        MaterialProperties materialProperties2 = obj2.propMaterial().get();
        materialProperties2.temperatureC_$eq(materialProperties2.temperatureC() + increment2);
    }

    private HeatTransfer$() {
        MODULE$ = this;
        this.HEAT_TRANSFER_COEFFICIENT = 0.1;
        this.MAX_TRANSFER_PER_STEP = 1000.0f;
    }
}

