# FrAug
FrAug is a data augmentation framework for time-series forecasting. It has two augmentation techniques: Frequency Masking and Frequency Mixing

## Getting Started
### Environment Requirements

First, please make sure you have installed Conda. Then, our environment can be installed by:
```
conda create -n FrAug python=3.7
conda activate FrAug
pip install -r requirements.txt
```

### Data Preparation
You can obtain all the eight benchmarks from [Google Drive](https://drive.google.com/drive/folders/1ZOYpTUa82_jCcxIdTmyr0LXQfvaM9vIy) provided in Autoformer. All the datasets are well pre-processed and can be used easily.

```
mkdir dataset
```
**Please put them in the `./dataset` directory**

## To reproduce the results in our paper

### Original performance of models
We provide scripts to facilitate reproducing main experiment results in our paper.

You can get the original performances of DLinear by running scripts in `scripts/original/DLinear`. For example, to get the original performance(without augmentations) of DLinear in ETTh1, you can run

```
sh scripts/original/DLinear/etth1.sh
```

For Autoformer and Informer, you can use scripts: `scripts/original/AutoformerInformer/Formers_Long.sh`. For FEDformer, you need to first `cd FEDformer`, then use the scripts `scripts/original.sh`. All results will be stored in `./logs/original`.

### Performance of models with FrAug
For DLinear, you can run the scripts in `scripts/FrAug/DLinear`. For Autoformer and Informer, the script is `scripts/FrAug/AutoformerInformer/Formers_Long.sh`. For FEDformer, you need to first `cd FEDformer`, then use the scripts `scripts/FrAug.sh`. All results will be stored in `./logs/FrAug`.

There are two hyperparameters in these scripts:
| Parameter      |                              Interpretation                          |
| ------------- | -------------------------------------------------------| 
| aug      | Set it to 1 for  Frequency Masking, 2 for Frequency Mixing                   |
| aug_rate      | The corresponding mask/mix rate   | 

## Code of FrAug
FrAug can be easily implemented, you can find its implementation in `exp/exp_main.py`, class `Augmentation` (line 371 to 414). And we apply the FrAug in the training loop (line 132 to 145). 