# Supplementaty code to The Limits of Inference Scaling Through Resampling

This repository contains the accompanying code to the paper with the title The Limits of Inference Scaling Through Resampling.

The experiments run for this work build on the following publications and their accompanying code repositories.

**EvalPlus ---**
[Is Your Code Generated by ChatGPT Really Correct? Rigorous Evaluation of Large Language Models for Code Generation](https://proceedings.neurips.cc/paper_files/paper/2023/hash/43e9d647ccd3e4b7b5baab53f0368686-Abstract-Conference.html) ([GitHub](https://github.com/evalplus/evalplus)) ([license](https://github.com/evalplus/evalplus/edit/master/LICENSE))

**RACE ---**
[Beyond Correctness: Benchmarking Multi-dimensional Code Generation for Large Language Models](https://arxiv.org/abs/2407.11470) ([GitHub](https://github.com/jszheng21/RACE)) ([license](https://github.com/jszheng21/RACE?tab=Apache-2.0-1-ov-file))

## General notes

### Contents

- Section 3: The sanitized code samples for HumanEval+ and MBPP+ can be found in the supplementary materials with `humaneval_evalplus.zip` and `mbpp_evalplus.zip`. Simply unzip the directories into `evalplus/`. Code for running the analysis and plotting figures is in `evalplus/visualizations.ipynb`.
- Section 4: Inference scaling curves are in `evalplus/scaling_curves.ipynb`
- Section 5: Parsed code samples for our experiments on code quality can be found in the `humaneval_race.zip` file. Unzip the directory into `race/`. Analysis and visualizations are in `race/visualizations.ipynb`

### Sample collection

To collect existing samples from the EvalPlus repository and generate new samples for additional models, we used their implementation provided [here](https://github.com/evalplus/evalplus/tree/937c46858cf8e687b31b5a728b7083d6e5a84971). For generating samples for our code quality experiments, we used the original implementation of the RACE benchmark provided [here](https://github.com/jszheng21/RACE/tree/3b8ee591abd5febd8ae8ec17c7b9907949c5e1d5).
