# A Study of Unsupervised Evaluation Metrics for Practical and Automatic Domain Adaptation

**Pytorch** code for "A Study of Unsupervised Evaluation Metrics for Practical and Automatic Domain Adaptation", NIPS 2023.

Paper ID 1772

## Requirements

```
# create conda env and install packages
conda create -y --name udametric python=3.7.9

conda activate udametric
# The code is tested on cuda10.1-cudnn7 and pytorch 1.6.0
conda install -y pytorch==1.6.0 torchvision==0.7.0 cudatoolkit=10.1 -c pytorch
conda install -y conda-build ipython pandas scipy pip

# install pip packages
pip install --upgrade pip
pip install -r requirements.txt
```



## Training Models to be evaluated

Train models by the DANN training method and the hyperparameter space in `./configs/dann_office.yml` on the A2W task of Office31

```
python automl.py --method DANN --cfg_file ./configs/dann_office.yml -d Office31 -s A -t W \
									--epochs 10 -i 2000 --seed 0 --gpus 0 1 \
									--output_path /tmp/office31_dann_A2W_logs
```

Train models by the DANN training method and the hyperparameter space in `./configs/dann_domainnet.yml` on the c2p task of DomainNet

```
python automl.py --method DANN --cfg_file ./configs/dann_domainnet.yml -d DomainNet -s c -t p \
									--epochs 10 -i 6000 --seed 0 --gpus 0 1 \
									--output_path /tmp/domainnet_dann_c2p_logs
```



## Evaluating and Plotting

Evaluate trained models with metrics 

```
python automl.py --method DANN --cfg_file ./configs/dann_domainnet.yml -d DomainNet -s c -t p \
									--epochs 10 -i 6000 --seed 0 --gpus 0 1 \
									--output_path /tmp/domainnet_dann_c2p_logs --eval_mode
```

Show the results of consistency

```
python draw.py --excels /tmp/domainnet_dann_c2p_logs
```



## Hyper-parameter Searching (with TPE searcher)

Seach the hyperparameter for DANN method and the hyperparameter searching space in `./configs/dann_domainnet_search.yml` 

```
python automl_optuna.py --method DANN --cfg_file ./configs/dann_domainnet_search.yml -d DomainNet -s c -t p --epochs 10 -i 6000 --seed 0 --gpu_id 0 --n_trials 50 --opt_metric search_metric --sampler TPE --output_path /tmp/domainnet_dann_c2p_tpesearch_newer
```



## Acknowledgment

The code base is based on https://github.com/thuml/Transfer-Learning-Library/tree/v0.2