# -*- coding: utf-8 -*-
import glob
import os

from PIL import Image
from tqdm.contrib.concurrent import process_map

source_dir = "/home/username/datasets/imagenet2012/"
save_dir = "/home/username/datasets/imagenet_processed/"

if not os.path.exists(save_dir):
    os.makedirs(save_dir)


def get_size(filename):
    # Obtain the file size: KB
    size = os.path.getsize(filename)
    return size / 1024


def compress_image(img_path, save_dir=save_dir, quality=30):
    ori_size = get_size(img_path)

    img = Image.open(img_path)
    img = img.convert('RGB')
    save_path = os.path.join(save_dir, os.path.relpath(img_path, source_dir))
    if not os.path.exists(os.path.dirname(save_path)):
        os.makedirs(os.path.dirname(save_path), exist_ok=True)
    img.save(save_path, quality=quality)

    o_size = get_size(save_path)

    print(f"compress ratio: {100 * (1 - o_size / ori_size):.2f}%")
    return save_path, o_size


if __name__ == '__main__':
    # compress_image(r'C:\Users\10158\Desktop\tmp\test_imgs\2.jpg', save_dir=r'C:\Users\10158\Desktop\tmp')
    process_map(compress_image, glob.glob(os.path.join(source_dir, '*', '*', '*')), max_workers=8, chunksize=1)
