function [a]=times(b,c,varargin)
%A=B.*C
%[A]=TIMES(B,C) Hadamard product of two TT-tensors
%
%
% TT-Toolbox 2.2, 2009-2012
%
%This is TT Toolbox, written by Ivan Oseledets et al.
%Institute of Numerical Mathematics, Moscow, Russia
%webpage: http://spring.inm.ras.ru/osel
%
%For all questions, bugs and suggestions please mail
%ivan.oseledets@gmail.com
%---------------------------

if (nargin == 2)    
    if b.d ~= c.d   % if shapes not the same, do broadcasting        
        if b.d > c.d 
            [c,b]=deal(b,c); % swap b and c, so that b is always the smaller one
        end         
        [ib, ~]=ismember(b.n, c.n);  %check whether every element of b.n is in c.n.       
        if any(ib==0)
           error('Mode sizes do not match, broadcasting failed.');
        else
            loc=zeros(b.d,1);
            cn=c.n;
            [~, loc(1)]=ismember(b.n(1), cn);        
            for i=2:b.d 
                cn(loc(i-1)) = -1; 
                [~, loc(i)]=ismember(b.n(i), cn);                
            end             
        end  % here I didn't check whether loc is in ascending order...
        
        b=add_non_essential_dims(b, c.n, loc); % this makes b and c the same shape.
    end     
 
    d=b.d; n=b.n; crb=b.core; crc=c.core; rb=b.r; rc=c.r;
    psb=b.ps; psc=c.ps;
    %Ranks are just a product
    a=tt_tensor;
    ra=rb.*rc;
    psa=cumsum([1;n(1:d).*ra(1:d).*ra(2:d+1)]);
    sz=dot(n(1:d).*ra(1:d),ra(2:d+1));
    cra=zeros(sz,1);
    for i=1:d
       cr1=crb(psb(i):psb(i+1)-1);
       cr2=crc(psc(i):psc(i+1)-1);
       cr1=reshape(cr1,[rb(i),n(i),rb(i+1)]);       
       cr2=reshape(cr2,[rc(i),n(i),rc(i+1)]);
       % rewrite in in the vectorized form
       cr1 = permute(cr1, [2, 1, 3]);
       cr1 = reshape(cr1, n(i)*rb(i)*rb(i+1), 1);
       ons = ones(1, rc(i)*rc(i+1));
       cr1 = cr1*ons;
       cr1 = reshape(cr1, n(i), rb(i), rb(i+1), rc(i), rc(i+1));
       cr1 = permute(cr1, [1, 2, 4, 3, 5]);
       cr1 = reshape(cr1, n(i), rb(i)*rc(i)*rb(i+1)*rc(i+1));
       cr2 = permute(cr2, [2, 1, 3]);
       cr2 = reshape(cr2, n(i)*rc(i)*rc(i+1), 1);
       ons = ones(1, rb(i)*rb(i+1));
       cr2 = cr2*ons;
       cr2 = reshape(cr2, n(i), rc(i), rc(i+1), rb(i), rb(i+1));
       cr2 = permute(cr2, [1, 4, 2, 5, 3]);
       cr2 = reshape(cr2, n(i), rb(i)*rc(i)*rb(i+1)*rc(i+1));       
       cr = cr1.*cr2;
       cr = reshape(cr, n(i), rb(i)*rc(i), rb(i+1)*rc(i+1));
       cr = permute(cr, [2, 1, 3]);
%        cr=zeros(ra(i),n(i),ra(i+1));
%        for j=1:n(i)
%           cr(:,j,:)=kron(reshape(cr1(:,j,:),rb(i),rb(i+1)),reshape(cr2(:,j,:),rc(i),rc(i+1)));
%        end
       cra(psa(i):psa(i+1)-1)=cr(:);
    end
    a.d=d;
    a.n=n;
    a.r=ra;
    a.ps=psa;
    a.core=cra;
    a.over=erank(a)-max(max(erank(b)-b.over,erank(c)-c.over),0);
elseif (nargin == 3)
     error('Krylov method is not yet supported, come again later');
end
return
end
