function [tt]=tt_qcirc(x,d)
% returns the multilevel circulant matrix tt generated by the multi-dimensional input vector x 
% in the QTT format
%
% The size of the input vector is 2^d(1) x ... x 2^d(D),
% The output matrix is square of order 2^d(1) x ... x 2^d(D).
%
% April 20, 2011
% Vladimir Kazeev
% vladimir.kazeev@gmail.com
% INM RAS
% Moscow, Russia
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% For details please see the preprint
% http://www.mis.mpg.de/publications/preprints/2011/prepr2011-36.html
% Vladimir A. Kazeev, Boris N. Khoromskij and Eugene E. Tyrtyshnikov
% Multilevel Toeplitz matrices generated by QTT tensor-structured vectors and convolution with logarithmic complexity
% January 12, 2012
% Vladimir Kazeev,
% Seminar for Applied Mathematics, ETH Zurich
% vladimir.kazeev@sam.math.ethz.ch
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tt=tt_qshiftstack_p(d);
tt=tt_qreshape(tt,3,[4*ones(sum(d),1),2*ones(sum(d),1)]);
tt=tt_mv(tt,x);
tt=tt_qreshape(tt,1,2*ones(sum(d),2));

return
end
