function [tt]=tt_qconv(x,y,d)

% returns the non-periodic convolution in the QTT format
% of vectors x and y given in the QTT format
% using the exact TT matvec
%
% x should be of size 2^l(1) x ... x 2^l(d) x 2^l(d+1)
% y should be of size 2^l(1) x ... x 2^l(d)
% THEN the output is of size 2^l(1) x ... x 2^l(d)
%
% June 16, 2011
% Vladimir Kazeev
% vladimir.kazeev@gmail.com
% INM RAS
% Moscow, Russia
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% For details please see the preprint
% http://www.mis.mpg.de/publications/preprints/2011/prepr2011-36.html
% Vladimir A. Kazeev, Boris N. Khoromskij and Eugene E. Tyrtyshnikov
% Multilevel Toeplitz matrices generated by QTT tensor-structured vectors and convolution with logarithmic complexity
% January 12, 2012
% Vladimir Kazeev,
% Seminar for Applied Mathematics, ETH Zurich
% vladimir.kazeev@sam.math.ethz.ch
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

D=numel(d);
% first, we construct the generating tensor
tt=tt_qshiftstack(d);
% then we reshape the generating tensor into a matrix
sz=[];
for K=1:D
	sz=[sz;4*ones(d(K),1),2*ones(d(K),1);1,2];
end
tt=tt_qreshape(tt,3,sz);
% and perform the matrix-vector multiplication to construct the vectorization of the Toeplitz matrix 
tt=tt_mv(tt,x);
% now we get rid of the void dimension left
tt1=cell(sum(d),1);
ind=0;
ind1=0;
for K=1:D
	for k=1:d(K)-1
		tt1{ind1+k}=tt{ind+k};
	end	
	
	p=size(tt{ind+d(K)},2);
	q=size(tt{ind+d(K)},3);
	r=size(tt{ind+d(K)+1},3);
	tt1{ind1+d(K)}=reshape(reshape(tt{ind+d(K)},[4*p,q])*reshape(tt{ind+d(K)+1},[q,r]),[4,p,r]);

	ind=ind+d(K)+1;
	ind1=ind1+d(K);
end
tt=tt1;
% next, reshape the vectorization into a matrix
tt=tt_qreshape(tt,1,2*ones(sum(d),2));
% now we multiply the circulant matrix by the second operand
tt=tt_mv(tt,y);

return
end