function [tt]=tt_qltrtoepl(x)

% returns the multilevel lower-triangular Toeplitz matrix tt generated by the multi-dimensional input vector x 
% in the QTT format
%
% If the size of the input vector is N,
% then the size of the output matrix is N x N.
%
% April 20, 2011
% Vladimir Kazeev
% vladimir.kazeev@gmail.com
% INM RAS
% Moscow, Russia
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% For details please see the preprint
% http://www.mis.mpg.de/publications/preprints/2011/prepr2011-36.html
% Vladimir A. Kazeev, Boris N. Khoromskij and Eugene E. Tyrtyshnikov
% Multilevel Toeplitz matrices generated by QTT tensor-structured vectors and convolution with logarithmic complexity
% January 12, 2012
% Vladimir Kazeev,
% Seminar for Applied Mathematics, ETH Zurich
% vladimir.kazeev@sam.math.ethz.ch
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

d=size(x,1);
tt=tt_qshiftstack_q(d);
tt=tt_qreshape(tt,3,[4*ones(d,1),2*ones(d,1)]);
tt=tt_mv(tt,x);
tt=tt_qreshape(tt,1,2*ones(d,2));

return
end
